/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider;

import com.atlassian.fugue.Either;
import com.atlassian.jira.plugin.devstatus.provider.data.ExceptionThrownError;
import com.atlassian.jira.plugin.devstatus.provider.data.FetchError;
import com.atlassian.jira.plugin.devstatus.provider.source.cache.RawJsonToStringDeserialiser;
import com.atlassian.jira.rest.Dates;
import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonRawValue;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@JsonAutoDetect(value={JsonMethod.NONE})
public final class DataProviderResponse {
    private static Charset UTF8 = Charset.forName("utf-8");
    @Nonnull
    private final Either<FetchError, FetchSuccess> either;

    public static DataProviderResponse success(@Nonnull byte[] json) {
        return DataProviderResponse.success(json, null);
    }

    public static DataProviderResponse success(@Nonnull byte[] json, @Nullable Date staleAfter) {
        return new DataProviderResponse(json, staleAfter);
    }

    public static DataProviderResponse success(@Nonnull String json, @Nullable Date staleAfter) {
        return DataProviderResponse.success(json.getBytes(UTF8), staleAfter);
    }

    public static DataProviderResponse failure(@Nonnull Throwable throwable) {
        return DataProviderResponse.failure(new ExceptionThrownError((Throwable)Preconditions.checkNotNull((Object)throwable, (Object)"throwable")));
    }

    public static DataProviderResponse failure(@Nonnull FetchError fetchError) {
        return new DataProviderResponse(fetchError);
    }

    private DataProviderResponse(@Nonnull FetchError fetchError) {
        this.either = Either.left((Object)Preconditions.checkNotNull((Object)fetchError, (Object)"fetchError"));
    }

    @JsonCreator
    DataProviderResponse(@Nonnull @JsonProperty(value="value") String json, @Nullable @JsonProperty(value="expiry") Date staleAfter) {
        this(json.getBytes(UTF8), staleAfter);
    }

    private DataProviderResponse(byte[] json, Date staleAfter) {
        this.either = Either.right((Object)new FetchSuccess(json, staleAfter));
    }

    public boolean isSuccessful() {
        return this.either.isRight();
    }

    public FetchError error() {
        return (FetchError)this.either.left().get();
    }

    @JsonProperty(value="value")
    @JsonRawValue
    @JsonDeserialize(using=RawJsonToStringDeserialiser.class)
    public String json() {
        return new String(this.jsonBytes(), UTF8);
    }

    public byte[] jsonBytes() {
        return ((FetchSuccess)this.either.right().get()).payload;
    }

    @Nullable
    @JsonProperty(value="expiry")
    @XmlJavaTypeAdapter(value=Dates.DateTimeAdapter.class)
    public Date staleAfter() {
        return ((FetchSuccess)this.either.right().get()).staleAfter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataProviderResponse that = (DataProviderResponse)o;
        return this.either.equals(that.either);
    }

    public int hashCode() {
        return this.either.hashCode();
    }

    static class FetchSuccess {
        private final byte[] payload;
        private final Date staleAfter;

        FetchSuccess(byte[] payload, Date staleAfter) {
            this.payload = payload;
            this.staleAfter = staleAfter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FetchSuccess fetchSuccess = (FetchSuccess)o;
            if (!Arrays.equals(this.payload, fetchSuccess.payload)) {
                return false;
            }
            return !(this.staleAfter != null ? !this.staleAfter.equals(fetchSuccess.staleAfter) : fetchSuccess.staleAfter != null);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.payload);
            result = 31 * result + (this.staleAfter != null ? this.staleAfter.hashCode() : 0);
            return result;
        }
    }
}

