/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.fugue.Either;
import com.atlassian.fusion.schema.summary.Summary;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.SummaryTarget;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSummaryService;
import com.atlassian.jira.plugin.devstatus.api.DevStatusValidationService;
import com.atlassian.jira.plugin.devstatus.impl.PermissionHelper;
import com.atlassian.jira.plugin.devstatus.provider.Coordinator;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.IssueDataRequest;
import com.atlassian.jira.plugin.devstatus.provider.data.FetchError;
import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryData;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryDataItem;
import com.atlassian.jira.plugin.devstatus.rest.DataErrorBean;
import com.atlassian.jira.plugin.devstatus.rest.DetailBean;
import com.atlassian.jira.plugin.devstatus.rest.SummaryBean;
import com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean;
import com.atlassian.jira.plugin.devstatus.summary.Aggregator;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryDataWithSource;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryJsonDataItemWithSource;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService
@Named
public class DefaultDevStatusSummaryService
implements DevStatusSummaryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultDevStatusSummaryService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String DETAIL_INSTANCE = "_instance";
    private final List<Aggregator> aggregators;
    private final Coordinator coordinator;
    private final DevStatusValidationService devStatusValidationService;
    private final IssueManager issueManager;
    private final PermissionHelper permissionHelper;

    @Inject
    public DefaultDevStatusSummaryService(List<Aggregator> aggregators, Coordinator coordinator, DevStatusValidationService devStatusValidationService, @ComponentImport IssueManager issueManager, PermissionHelper permissionHelper) {
        this.aggregators = this.validateAggregators(aggregators);
        this.coordinator = coordinator;
        this.devStatusValidationService = devStatusValidationService;
        this.issueManager = issueManager;
        this.permissionHelper = permissionHelper;
    }

    @VisibleForTesting
    List<Aggregator> validateAggregators(List<Aggregator> aggregators) {
        Collection aggregatorsWithoutNulls = Collections2.filter(aggregators, (Predicate)Predicates.notNull());
        if (aggregatorsWithoutNulls.isEmpty()) {
            throw new RuntimeException("No non-null aggregators are configured.");
        }
        ImmutableMap grouped = Multimaps.index((Iterable)aggregatorsWithoutNulls, (Function)new Function<Aggregator, String>(){

            public String apply(Aggregator input) {
                return input.getType();
            }
        }).asMap();
        if (grouped.size() != aggregatorsWithoutNulls.size()) {
            ArrayList messages = Lists.newArrayList();
            for (Map.Entry entry : grouped.entrySet()) {
                if (((Collection)entry.getValue()).size() <= 1) continue;
                messages.add("(" + (String)entry.getKey() + ": " + StringUtils.join((Iterable)Collections2.transform((Collection)((Collection)entry.getValue()), (Function)new Function<Aggregator, String>(){

                    public String apply(Aggregator input) {
                        return input.getClass().getSimpleName();
                    }
                }), (String)", ") + ")");
            }
            throw new RuntimeException("Duplicate summary aggregators: " + StringUtils.join((Iterable)messages, (String)", "));
        }
        return ImmutableList.copyOf((Collection)aggregatorsWithoutNulls);
    }

    @Override
    public ServiceOutcome<SummaryBean> getSummaryData(long issueId, @Nullable ApplicationUser user) {
        return this.validateAndLoadIssues(issueId, user, new Function<IssueDataRequest, SummaryBean>(){

            public SummaryBean apply(IssueDataRequest summaryDataRequest) {
                return DefaultDevStatusSummaryService.this.combinedAggregateData(summaryDataRequest);
            }
        });
    }

    @Override
    @Nonnull
    public ServiceOutcome<DetailBean> getDetailData(long issueId, final @Nonnull String applicationType, final @Nonnull String dateType, @Nullable ApplicationUser user) {
        Preconditions.checkNotNull((Object)applicationType, (Object)"applicationType");
        Preconditions.checkNotNull((Object)dateType, (Object)"dateType");
        return this.validateAndLoadIssues(issueId, user, new Function<IssueDataRequest, DetailBean>(){

            public DetailBean apply(IssueDataRequest detailDataRequest) {
                SummaryData summaryData = DefaultDevStatusSummaryService.this.coordinator.fetchDetailData(detailDataRequest, applicationType, dateType);
                return new DetailBean((Collection<JsonNode>)this.getDetailJson(summaryData), (Collection<DataErrorBean>)DefaultDevStatusSummaryService.this.aggregateTransientErrors(summaryData));
            }

            private List<JsonNode> getDetailJson(SummaryData summaryData) {
                ArrayList<JsonNode> data = new ArrayList<JsonNode>();
                for (SummaryDataItem item : summaryData) {
                    Either result = DefaultDevStatusSummaryService.this.convertToJsonNode(item, ObjectNode.class);
                    if (result == null || !result.isRight()) continue;
                    ObjectNode details = (ObjectNode)result.right().get();
                    details.put(DefaultDevStatusSummaryService.DETAIL_INSTANCE, OBJECT_MAPPER.valueToTree((Object)item.getSource()));
                    data.add((JsonNode)details);
                }
                return data;
            }
        });
    }

    private <T> ServiceOutcome<T> validateAndLoadIssues(long issueId, ApplicationUser user, Function<IssueDataRequest, T> getData) {
        Either<String, Issue> issue = this.devStatusValidationService.validateIssueId(issueId, user);
        if (issue.isLeft()) {
            return ServiceOutcomeImpl.error((String)((String)issue.left().get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        Issue issueObj = (Issue)issue.right().get();
        ServiceOutcome<Boolean> permission = this.devStatusValidationService.checkPermission(issueObj, user);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        Set allIssueKeys = this.issueManager.getAllIssueKeys(Long.valueOf(issueId));
        IssueDataRequest issueDataRequest = new IssueDataRequest(issueObj.getId(), allIssueKeys);
        return ServiceOutcomeImpl.ok((Object)getData.apply((Object)issueDataRequest));
    }

    private SummaryBean combinedAggregateData(IssueDataRequest summaryRequest) {
        SummaryData summaryData = this.coordinator.fetchSummaryData(summaryRequest);
        return this.combineAggregatedData(summaryRequest.issueId(), summaryData);
    }

    @Override
    @Nonnull
    public SummaryBean combineAggregatedData(long issueId, SummaryData summaryData) {
        Collection<SummaryDataWithSource> summaryDataWithSources = this.convertToJsonItems(summaryData);
        Map<String, SummaryItemBean> summaryItemMap = this.aggregateSummary(summaryDataWithSources, issueId);
        Collection<DataErrorBean> transientErrors = this.aggregateTransientErrors(summaryData);
        Collection<DataErrorBean> configErrors = this.aggregateConfigErrors(summaryData);
        return new SummaryBean(summaryItemMap, transientErrors, configErrors);
    }

    @VisibleForTesting
    Collection<SummaryDataWithSource> convertToJsonItems(SummaryData summaryData) {
        Collection converted = Collections2.transform(summaryData.getItems(), (Function)new Function<SummaryDataItem, SummaryDataWithSource>(){

            public SummaryDataWithSource apply(SummaryDataItem summaryDataItem) {
                Either converted = DefaultDevStatusSummaryService.this.convertToJsonNode(summaryDataItem, Summary.class);
                return converted == null ? null : new SummaryDataWithSource(summaryDataItem.getSource(), (Either<FetchError, Summary>)converted);
            }
        });
        return Collections2.filter((Collection)converted, (Predicate)Predicates.notNull());
    }

    private <T> Either<FetchError, T> convertToJsonNode(SummaryDataItem summaryDataItem, Class<T> resultType) {
        try {
            DataProviderResponse result = summaryDataItem.getResult();
            return !result.isSuccessful() ? Either.left((Object)result.error()) : Either.right((Object)OBJECT_MAPPER.readValue(result.jsonBytes(), resultType));
        }
        catch (IOException e) {
            log.info("Unable to parse result from " + summaryDataItem.getSource().getName() + ". Exception: " + e.getMessage());
            return null;
        }
    }

    @VisibleForTesting
    Map<String, SummaryItemBean> aggregateSummary(Collection<SummaryDataWithSource> summaryData, long issueId) {
        HashMap summaryItemMap = Maps.newHashMap();
        for (Aggregator aggregator : this.aggregators) {
            Collection<SummaryJsonDataItemWithSource> flattened;
            SummaryItemBean item = aggregator.aggregate(flattened = this.filterAndFlatten(summaryData, aggregator.getType()), issueId);
            if (item == null) continue;
            summaryItemMap.put(aggregator.getType(), item);
        }
        return summaryItemMap;
    }

    @VisibleForTesting
    Collection<SummaryJsonDataItemWithSource> filterAndFlatten(Collection<SummaryDataWithSource> summaryDataWithSources, String type) {
        ArrayList flatterned = Lists.newArrayList();
        for (SummaryDataWithSource summaryDataItem : summaryDataWithSources) {
            Summary root;
            Map<String, List<SummaryTarget>> targets;
            Either<FetchError, Summary> result = summaryDataItem.getResult();
            if (!result.isRight() || !MapUtils.isNotEmpty(targets = (root = (Summary)result.right().get()).getTargets())) continue;
            final Source source = summaryDataItem.getSource();
            if (!MapUtils.isNotEmpty(targets) && !StringUtils.isNotBlank((CharSequence)source.getType())) continue;
            for (SummaryTarget summaryJsonDataItem : Iterables.concat(targets.values())) {
                if (summaryJsonDataItem.getType() == null || !type.equals(summaryJsonDataItem.getType().getId())) continue;
                flatterned.addAll(Collections2.transform(summaryJsonDataItem.getObjectsRaw(), (Function)new Function<SummaryObjectMap, SummaryJsonDataItemWithSource>(){

                    public SummaryJsonDataItemWithSource apply(@Nullable SummaryObjectMap input) {
                        return input == null ? null : new SummaryJsonDataItemWithSource(source, input);
                    }
                }));
            }
        }
        return Collections2.filter((Collection)flatterned, (Predicate)Predicates.notNull());
    }

    private Collection<DataErrorBean> aggregateTransientErrors(SummaryData summaryData) {
        return Collections2.transform((Collection)Collections2.filter(summaryData.getItems(), (Predicate)IsError.TRANSIENT), (Function)ToDataErrorBean.TRANSFORM);
    }

    private Collection<DataErrorBean> aggregateConfigErrors(SummaryData summaryData) {
        if (this.permissionHelper.isLoggedInAsAdmin() || this.permissionHelper.isLoggedInAsSysAdmin()) {
            return Collections2.transform((Collection)Collections2.filter(summaryData.getItems(), (Predicate)IsError.NON_TRANSIENT), (Function)ToDataErrorBean.TRANSFORM);
        }
        return ImmutableList.of();
    }

    private static enum ToDataErrorBean implements Function<SummaryDataItem, DataErrorBean>
    {
        TRANSFORM;


        public DataErrorBean apply(SummaryDataItem item) {
            DataProviderResponse result = item.getResult();
            if (!result.isSuccessful()) {
                return new DataErrorBean(item.getSource(), result.error().getDescription());
            }
            return null;
        }
    }

    private static enum IsError implements Predicate<SummaryDataItem>
    {
        TRANSIENT(true),
        NON_TRANSIENT(false);

        private final boolean isTransient;

        private IsError(boolean isTransient) {
            this.isTransient = isTransient;
        }

        public boolean apply(@Nullable SummaryDataItem item) {
            if (item != null) {
                DataProviderResponse response = item.getResult();
                return !response.isSuccessful() && response.error().isTransient() == this.isTransient;
            }
            return false;
        }
    }
}

