/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.devstatus.api.CallToAction;
import com.atlassian.jira.plugin.devstatus.api.DevStatusCtaService;
import com.atlassian.jira.plugin.devstatus.api.DevStatusValidationService;
import com.atlassian.jira.plugin.devstatus.api.RemoteApp;
import com.atlassian.jira.plugin.devstatus.api.RemoteApps;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService
@Named
public class DefaultDevStatusCtaService
implements DevStatusCtaService {
    static final String CONTEXT_KEY_ISSUE = "issue";
    static final String CALL_TO_ACTIONS_SECTION = "devstatus-cta-list";
    private final DevStatusValidationService devStatusValidationService;
    private final SimpleLinkManager simpleLinkManager;
    private final I18nHelper i18nHelper;

    @Inject
    public DefaultDevStatusCtaService(DevStatusValidationService devStatusValidationService, @ComponentImport SimpleLinkManager simpleLinkManager, @ComponentImport I18nHelper i18nHelper) {
        this.devStatusValidationService = devStatusValidationService;
        this.simpleLinkManager = simpleLinkManager;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public ServiceOutcome<RemoteApps> getRemoteApps(@Nonnull String cta, long issueId, @Nullable ApplicationUser user) {
        Either<String, String> callToAction = this.devStatusValidationService.validateCta(cta, user);
        if (callToAction.isLeft()) {
            return ServiceOutcomeImpl.error((String)((String)callToAction.left().get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        Either<String, Issue> issue = this.devStatusValidationService.validateIssueId(issueId, user);
        if (issue.isLeft()) {
            return ServiceOutcomeImpl.error((String)((String)issue.left().get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        ServiceOutcome<Boolean> permission = this.devStatusValidationService.checkPermission((Issue)issue.right().get(), user);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        List links = this.simpleLinkManager.getLinksForSection((String)callToAction.right().get(), ApplicationUsers.toDirectoryUser((ApplicationUser)user), this.getJiraHelper((Issue)issue.right().get()));
        String prompt = this.i18nHelper.getText((String)callToAction.right().get() + ".prompt");
        return ServiceOutcomeImpl.ok((Object)new RemoteApps(this.convertLinks(links), prompt));
    }

    private List<RemoteApp> convertLinks(List<SimpleLink> links) {
        return Lists.transform(links, (Function)new Function<SimpleLink, RemoteApp>(){

            public RemoteApp apply(SimpleLink link) {
                Map params = link.getParams();
                return new RemoteApp(link.getLabel(), link.getUrl(), (String)params.get("baseUrl"), link.getIconUrl(), (String)params.get("iconClass"), (String)params.get("applicationType"));
            }
        });
    }

    @Override
    public ServiceOutcome<Boolean> hasRemoteApps(@Nonnull String cta, @Nonnull Issue originalIssue, @Nullable ApplicationUser user) {
        Either<String, String> callToAction = this.devStatusValidationService.validateCta(cta, user);
        if (callToAction.isLeft()) {
            return ServiceOutcomeImpl.error((String)((String)callToAction.left().get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        Either<String, Issue> issue = this.devStatusValidationService.validateIssue(originalIssue, user);
        if (issue.isLeft()) {
            return ServiceOutcomeImpl.error((String)((String)issue.left().get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        ServiceOutcome<Boolean> permission = this.devStatusValidationService.checkPermission((Issue)issue.right().get(), user);
        if (!permission.isValid()) {
            return permission;
        }
        List links = this.simpleLinkManager.getLinksForSection((String)callToAction.right().get(), ApplicationUsers.toDirectoryUser((ApplicationUser)user), this.getJiraHelper((Issue)issue.right().get()));
        return ServiceOutcomeImpl.ok((Object)(!links.isEmpty() ? 1 : 0));
    }

    @Override
    public ServiceOutcome<List<CallToAction>> getCallToActions(@Nonnull Issue originalIssue, @Nullable ApplicationUser user) {
        Either<String, Issue> issue = this.devStatusValidationService.validateIssue(originalIssue, user);
        if (issue.isLeft()) {
            return ServiceOutcomeImpl.error((String)((String)issue.left().get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        ServiceOutcome<Boolean> permission = this.devStatusValidationService.checkPermission((Issue)issue.right().get(), user);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        List links = this.simpleLinkManager.getLinksForSection(CALL_TO_ACTIONS_SECTION, ApplicationUsers.toDirectoryUser((ApplicationUser)user), this.getJiraHelper((Issue)issue.right().get()));
        return ServiceOutcomeImpl.ok((Object)Lists.transform((List)links, (Function)new Function<SimpleLink, CallToAction>(){

            public CallToAction apply(SimpleLink link) {
                return new CallToAction(link.getId(), link.getUrl(), link.getLabel(), link.getParams() == null ? null : (String)link.getParams().get("iconClass"), link.getStyleClass());
            }
        }));
    }

    @Override
    public ServiceOutcome<Boolean> hasCallToActions(@Nonnull Issue originalIssue, @Nullable ApplicationUser user) {
        Either<String, Issue> issue = this.devStatusValidationService.validateIssue(originalIssue, user);
        if (issue.isLeft()) {
            return ServiceOutcomeImpl.error((String)((String)issue.left().get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        ServiceOutcome<Boolean> permission = this.devStatusValidationService.checkPermission((Issue)issue.right().get(), user);
        if (!permission.isValid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        List links = this.simpleLinkManager.getLinksForSection(CALL_TO_ACTIONS_SECTION, ApplicationUsers.toDirectoryUser((ApplicationUser)user), this.getJiraHelper((Issue)issue.right().get()));
        return ServiceOutcomeImpl.ok((Object)(links.size() > 0 ? 1 : 0));
    }

    private JiraHelper getJiraHelper(Issue issue) {
        return new JiraHelper(ExecutingHttpRequest.get(), issue.getProjectObject(), (Map)ImmutableMap.of((Object)CONTEXT_KEY_ISSUE, (Object)issue));
    }
}

