/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.guava.collect.Sets;
import com.atlassian.jira.plugin.devstatus.impl.Capability;
import com.atlassian.jira.plugin.devstatus.impl.NavigationKeys;
import java.util.Set;

public enum ApplicationCapabilities {
    STASH{

        @Override
        public Set<Capability> expected() {
            return Sets.newHashSet(CREATE_BRANCH, STATUS_PULLREQUEST, STATUS_REPOSITORY);
        }
    }
    ,
    BITBUCKET{

        @Override
        public Set<Capability> expected() {
            return Sets.newHashSet(CREATE_BRANCH, STATUS_PULLREQUEST, STATUS_REPOSITORY);
        }
    }
    ,
    GITHUB{

        @Override
        public Set<Capability> expected() {
            return Sets.newHashSet(STATUS_PULLREQUEST, STATUS_REPOSITORY);
        }
    }
    ,
    GITHUB_ENTERPRISE{

        @Override
        public Set<Capability> expected() {
            return Sets.newHashSet(STATUS_PULLREQUEST, STATUS_REPOSITORY);
        }
    }
    ,
    BAMBOO{

        @Override
        public Set<Capability> expected() {
            return Sets.newHashSet(STATUS_BUILD, STATUS_DEPLOYMENT);
        }
    }
    ,
    FECRU{

        @Override
        public Set<Capability> expected() {
            return Sets.newHashSet(CREATE_REVIEW, STATUS_REVIEW, STATUS_REPOSITORY, STATUS_BRANCH);
        }
    }
    ,
    UNKNOWN{

        @Override
        public Set<Capability> expected() {
            return 7.allCapabilities();
        }
    }
    ,
    NO_CAPABILITIES{

        @Override
        public Set<Capability> expected() {
            return Sets.newConcurrentHashSet();
        }
    };

    public static final Capability CREATE_BRANCH;
    public static final Capability CREATE_REVIEW;
    public static final Capability STATUS_BRANCH;
    public static final Capability STATUS_PULLREQUEST;
    public static final Capability STATUS_REPOSITORY;
    public static final Capability STATUS_REVIEW;
    public static final Capability STATUS_BUILD;
    public static final Capability STATUS_DEPLOYMENT;

    public abstract Set<Capability> expected();

    public static Set<Capability> allCapabilities() {
        return Sets.newHashSet(CREATE_BRANCH, STATUS_PULLREQUEST, STATUS_REPOSITORY, STATUS_REVIEW, STATUS_BUILD, STATUS_DEPLOYMENT, CREATE_REVIEW);
    }

    static ApplicationCapabilities fromAppType(ApplicationType appType) {
        if (appType instanceof BambooApplicationType) {
            return BAMBOO;
        }
        if (appType instanceof FishEyeCrucibleApplicationType) {
            return FECRU;
        }
        if (appType instanceof StashApplicationType) {
            return STASH;
        }
        return UNKNOWN;
    }

    public static ApplicationCapabilities fromApplink(ApplicationLink applicationLink) {
        return ApplicationCapabilities.fromAppType(applicationLink.getType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ApplicationCapabilities{");
        for (Capability capability : this.expected()) {
            sb.append(capability.toString());
        }
        sb.append('}');
        return sb.toString();
    }

    static {
        CREATE_BRANCH = new Capability(NavigationKeys.CREATE_BRANCH, "create-branch", 10000);
        CREATE_REVIEW = new Capability(NavigationKeys.CREATE_REVIEW, "create-review", 9000);
        STATUS_BRANCH = new Capability("dev-status-detail-pullrequest", "detail.branch", 8000);
        STATUS_PULLREQUEST = new Capability("dev-status-detail-pullrequest", "detail.pullrequest", 7000);
        STATUS_REPOSITORY = new Capability("dev-status-detail-repository", "detail.repository", 6000);
        STATUS_REVIEW = new Capability("dev-status-detail-review", "detail.review", 5000);
        STATUS_BUILD = new Capability("dev-status-detail-build", "detail.build", 4000);
        STATUS_DEPLOYMENT = new Capability("dev-status-detail-deployment-environment", "detail.deployment.environment", 3000);
    }
}

