/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.cache;

import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyQuery;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonStore<T> {
    @Nonnull
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    @Nonnull
    private final String entityName;
    @Nonnull
    private final Class<T> storedClass;
    @Nonnull
    private final ObjectMapper objectMapper;

    public JsonStore(@Nonnull JsonEntityPropertyManager jsonEntityPropertyManager, @Nonnull String entityName, @Nonnull Class<T> storedClass) {
        this.jsonEntityPropertyManager = (JsonEntityPropertyManager)Preconditions.checkNotNull((Object)jsonEntityPropertyManager, (Object)"jsonEntityPropertyManager");
        this.entityName = (String)Preconditions.checkNotNull((Object)entityName, (Object)"entityName");
        this.storedClass = (Class)Preconditions.checkNotNull(storedClass, (Object)"storedClass");
        this.objectMapper = new ObjectMapper();
        if (!this.objectMapper.canSerialize(storedClass)) {
            throw new IllegalArgumentException("Can't serialise " + storedClass);
        }
    }

    @Nullable
    public T get(long issueId, String key) {
        EntityProperty json = this.jsonEntityPropertyManager.get(this.entityName, Long.valueOf(issueId), key);
        if (json == null) {
            return null;
        }
        return this.propertyToObject(json);
    }

    @Nonnull
    public Map<String, T> getAll(long issueId) {
        List jsons = ((EntityPropertyQuery.ExecutableQuery)this.jsonEntityPropertyManager.query().entityName(this.entityName).entityId(Long.valueOf(issueId))).find();
        HashMap objectByKey = Maps.newHashMapWithExpectedSize((int)jsons.size());
        for (EntityProperty json : jsons) {
            objectByKey.put(json.getKey(), this.propertyToObject(json));
        }
        return objectByKey;
    }

    public void put(long issueId, String key, T value) {
        try {
            String valueAsJson = this.objectMapper.writeValueAsString(value);
            this.jsonEntityPropertyManager.put(this.entityName, Long.valueOf(issueId), key, valueAsJson);
        }
        catch (IOException e) {
            throw new RuntimeException("Error serialising value to JSON: " + value, e);
        }
    }

    private T propertyToObject(EntityProperty entityProperty) {
        String jsonObject = entityProperty.getValue();
        try {
            return (T)this.objectMapper.readValue(jsonObject, this.storedClass);
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserialising value from JSON: " + jsonObject, e);
        }
    }
}

