/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.api;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class RemoteApp {
    private final String name;
    private final String url;
    private final String baseUrl;
    private final String iconUrl;
    private final String iconClass;
    private final String applicationType;

    public RemoteApp(String name, String url, String baseUrl, String iconUrl, String iconClass, String applicationType) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Can not render a remote app without a name");
        this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"Can not render a remote app without any url");
        this.baseUrl = StringUtils.removeEnd((String)StringUtils.defaultString((String)baseUrl, (String)url), (String)"/");
        this.iconUrl = (String)StringUtils.defaultIfEmpty((CharSequence)iconUrl, null);
        this.iconClass = (String)StringUtils.defaultIfEmpty((CharSequence)iconClass, null);
        this.applicationType = applicationType;
        Preconditions.checkArgument((this.iconUrl != null || this.iconClass != null ? 1 : 0) != 0, (Object)"Can not render a remote app without either an iconUrl or iconClass");
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getIconClass() {
        return this.iconClass;
    }

    public String getApplicationType() {
        return this.applicationType;
    }
}

