/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.summary.objects;

import com.atlassian.fusion.schema.summary.SummaryObject;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.SummaryType;
import com.atlassian.fusion.schema.util.DateUtils;
import com.atlassian.fusion.schema.util.EnumUtils;
import com.google.common.base.Function;
import java.util.Date;

public class ReviewsObject
extends SummaryObject {
    public static SummaryType ID = new SummaryType("review");
    public static final Function<ReviewsObject, ReviewState> TO_STATE = new Function<ReviewsObject, ReviewState>(){

        public ReviewState apply(ReviewsObject input) {
            return input.getState();
        }
    };
    public static final Function<ReviewsObject, Date> TO_DUE_DATE = new Function<ReviewsObject, Date>(){

        public Date apply(ReviewsObject input) {
            return input.getDueDate();
        }
    };

    public ReviewsObject(SummaryObjectMap parent) {
        super(parent);
    }

    public ReviewsObject(Builder builder) {
        super(builder);
        this.putIfNotNull("state", EnumUtils.name(builder.state));
        this.putIfNotNull("dueDate", builder.dueDate);
    }

    public ReviewState getState() {
        return EnumUtils.valueOf(ReviewState.class, this.get("state"), ReviewState.UNKNOWN);
    }

    public Date getDueDate() {
        return this.getDate("dueDate");
    }

    public static class Builder
    extends SummaryObject.Builder<Builder> {
        private ReviewState state;
        private String dueDate;

        public Builder(ReviewState value) {
            this.state = value;
        }

        public Builder dueDate(Date value) {
            this.dueDate = DateUtils.format(value);
            return this;
        }

        @Deprecated
        public Builder dueDate(String value) {
            this.dueDate = value;
            return this;
        }

        public ReviewsObject build() {
            return new ReviewsObject(this);
        }
    }

    public static enum ReviewState {
        REVIEW,
        APPROVAL,
        SUMMARIZE,
        REJECTED,
        CLOSED,
        DRAFT,
        DEAD,
        UNKNOWN;

    }
}

