/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.summary.objects;

import com.atlassian.fusion.schema.summary.SummaryObject;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.SummaryType;
import com.atlassian.fusion.schema.util.EnumUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import org.apache.commons.lang.builder.CompareToBuilder;

public class DeploymentEnvironmentObject
extends SummaryObject {
    public static SummaryType ID = new SummaryType("deployment-environment");
    private final transient ProjectIdentifier projectIdentifier;
    public static final Predicate<? super DeploymentEnvironmentObject> IS_DEPLOYED = new Predicate<DeploymentEnvironmentObject>(){

        public boolean apply(DeploymentEnvironmentObject input) {
            return input != null && DeploymentState.DEPLOYED.equals((Object)input.getStatus());
        }
    };
    public static final Ordering<DeploymentEnvironmentObject> ORDERING_BY_POSITION = new Ordering<DeploymentEnvironmentObject>(){

        public int compare(DeploymentEnvironmentObject left, DeploymentEnvironmentObject right) {
            return new CompareToBuilder().append(left.getPosition(), right.getPosition()).toComparison();
        }
    };

    private DeploymentEnvironmentObject(SummaryObjectMap parent) {
        super(parent);
        Object projectUrl = this.get("projectUrl");
        String projectUrlString = projectUrl != null ? projectUrl.toString() : "nope";
        this.projectIdentifier = new ProjectIdentifier(this.get("project").toString(), projectUrlString);
    }

    public DeploymentEnvironmentObject(Builder builder) {
        super(builder);
        this.putIfNotNull("status", EnumUtils.name(builder.state));
        this.putIfNotNull("title", builder.name);
        this.put("id", builder.id);
        this.putIfNotNull("url", builder.url);
        this.put("position", builder.position);
        this.putIfNotNull("project", builder.projectName);
        this.put("projectId", builder.projectName);
        this.putIfNotNull("projectUrl", builder.projectUrl);
        this.projectIdentifier = new ProjectIdentifier(builder.projectName, builder.projectUrl);
    }

    public ProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public DeploymentState getStatus() {
        return EnumUtils.valueOf(DeploymentState.class, this.get("status"), DeploymentState.NOT_DEPLOYED);
    }

    public int getPosition() {
        Object position = this.get("position");
        return position != null ? Integer.parseInt(position.toString()) : 0;
    }

    public static class ProjectIdentifier {
        private final String name;
        private final String url;
        public static Ordering<ProjectIdentifier> ORDERING = new Ordering<ProjectIdentifier>(){

            public int compare(ProjectIdentifier left, ProjectIdentifier right) {
                return new CompareToBuilder().append((Object)left.name, (Object)right.name, String.CASE_INSENSITIVE_ORDER).append((Object)left.url, (Object)right.url).toComparison();
            }
        };

        public ProjectIdentifier(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectIdentifier that = (ProjectIdentifier)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.url.equals(that.url);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.url.hashCode();
            return result;
        }
    }

    public static class Builder
    extends SummaryObject.Builder<Builder> {
        private DeploymentState state;
        private String name;
        private long id;
        private String url;
        private int position;
        private String projectName;
        private long projectId;
        private String projectUrl;

        public Builder(DeploymentState state) {
            this.state = state;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder position(int position) {
            this.position = position;
            return this;
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder projectId(long projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder projectUrl(String projectUrl) {
            this.projectUrl = projectUrl;
            return this;
        }

        public DeploymentEnvironmentObject build() {
            return new DeploymentEnvironmentObject(this);
        }
    }

    public static enum DeploymentState {
        NOT_DEPLOYED,
        DEPLOYED;

    }
}

