/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.summary.objects;

import com.atlassian.fusion.schema.summary.SummaryObject;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.SummaryType;
import com.atlassian.fusion.schema.util.EnumUtils;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BuildsObject
extends SummaryObject {
    public static SummaryType ID = new SummaryType("build");
    public static Predicate<? super BuildsObject> isFailed = new BuildsObjectStatusPredicate(Status.FAILED);
    public static Predicate<? super BuildsObject> isSuccessful = new BuildsObjectStatusPredicate(Status.SUCCESS);
    public static Predicate<? super BuildsObject> isUnknown = new BuildsObjectStatusPredicate(Status.UNKNOWN);

    private BuildsObject(SummaryObjectMap parent) {
        super(parent);
    }

    private BuildsObject(Builder builder) {
        super(builder);
        this.putIfNotNull("planKey", builder.planKey);
        this.putIfNotNull("status", EnumUtils.name(builder.status));
        this.put("buildCount", builder.buildCount);
    }

    public Status getStatus() {
        return EnumUtils.valueOf(Status.class, this.get("status"), Status.UNKNOWN);
    }

    public static class Builder
    extends SummaryObject.Builder<Builder> {
        private Status status;
        private String planKey;
        private int buildCount;

        public Builder(Status value, int buildCount) {
            this.status = value;
            this.buildCount = buildCount;
        }

        public Builder planKey(String value) {
            this.planKey = value;
            return this;
        }

        public BuildsObject build() {
            return new BuildsObject(this);
        }
    }

    private static class BuildsObjectStatusPredicate
    implements Predicate<BuildsObject> {
        private final Status status;

        protected BuildsObjectStatusPredicate(@Nonnull Status status) {
            this.status = status;
        }

        public boolean apply(@Nullable BuildsObject input) {
            return input != null && this.status == input.getStatus();
        }
    }

    public static enum Status {
        FAILED,
        SUCCESS,
        UNKNOWN;

    }
}

