/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.summary;

import com.atlassian.fusion.schema.Json;
import com.atlassian.fusion.schema.summary.SummaryObject;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.SummaryType;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class SummaryTarget
extends Json {
    @JsonProperty
    private SummaryType type;
    @JsonProperty
    private List<SummaryObjectMap> objects = ImmutableList.of();

    private SummaryTarget() {
    }

    private SummaryTarget(Builder builder) {
        this.type = builder.type;
        this.objects = Lists.newArrayList((Iterable)builder.objects.build());
    }

    public SummaryType getType() {
        return this.type;
    }

    @JsonIgnore
    public List<SummaryObjectMap> getObjectsRaw() {
        return SummaryTarget.nonNullList(this.objects);
    }

    public <T extends SummaryObject> List<T> getObjects(final Class<T> type) {
        return Lists.transform(this.objects, (Function)new Function<SummaryObjectMap, T>(){

            public T apply(SummaryObjectMap object) {
                return object.as(type);
            }
        });
    }

    public static class Builder {
        private final ImmutableList.Builder<SummaryObjectMap> objects = ImmutableList.builder();
        private final SummaryType type;

        public Builder(SummaryType type) {
            this.type = type;
        }

        public Builder add(SummaryObject object) {
            this.objects.add((Object)object);
            return this;
        }

        public Builder addAll(Iterable<? extends SummaryObject> value) {
            this.objects.addAll(value);
            return this;
        }

        public Builder addAll(SummaryObject ... value) {
            this.objects.addAll(Arrays.asList(value));
            return this;
        }

        public SummaryTarget build() {
            return new SummaryTarget(this);
        }
    }
}

