/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.commit;

import com.atlassian.fusion.schema.Json;
import com.atlassian.fusion.schema.util.EnumUtils;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;

public class File
extends Json {
    @JsonProperty
    private String path;
    @JsonProperty
    private String url;
    @JsonProperty
    private String changeType;
    @JsonProperty
    private Integer linesAdded;
    @JsonProperty
    private Integer linesRemoved;

    private File() {
    }

    private File(Builder builder) {
        this.path = builder.path;
        this.url = builder.url;
        this.changeType = builder.changeType;
        this.linesAdded = builder.linesAdded;
        this.linesRemoved = builder.linesRemoved;
    }

    @Nonnull
    public String getPath() {
        return (String)Objects.firstNonNull((Object)this.path, (Object)"");
    }

    @Nonnull
    public String getUrl() {
        return (String)Objects.firstNonNull((Object)this.url, (Object)"");
    }

    @Nonnull
    public ChangeType getChangeType() {
        return EnumUtils.valueOf(ChangeType.class, this.changeType, ChangeType.UNKNOWN);
    }

    @Nullable
    public Integer getLinesAdded() {
        return this.linesAdded;
    }

    @Nullable
    public Integer getLinesRemoved() {
        return this.linesRemoved;
    }

    public static class Builder
    extends Json.AbstractBuilder<Builder> {
        private String path;
        private String url;
        private String changeType;
        private Integer linesAdded;
        private Integer linesRemoved;

        public Builder(String path, String url, ChangeType changeType) {
            this.path = path;
            this.url = url;
            this.changeType = changeType.name();
        }

        public Builder linesAdded(int value) {
            this.linesAdded = value;
            return this;
        }

        public Builder linesRemoved(int value) {
            this.linesRemoved = value;
            return this;
        }

        public File build() {
            return new File(this);
        }
    }

    public static enum ChangeType {
        ADDED,
        COPIED,
        DELETED,
        MODIFIED,
        MOVED,
        UNKNOWN;

    }
}

