/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.commit;

import com.atlassian.fusion.schema.Json;
import com.atlassian.fusion.schema.detail.branch.BaseBranch;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonProperty;

public class CommitBranches
extends Json {
    @JsonProperty
    private final int totalCount;
    @JsonProperty
    private final List<BaseBranch> branches;

    private CommitBranches() {
        this.totalCount = 0;
        this.branches = null;
    }

    private CommitBranches(int totalCount, List<BaseBranch> branches) {
        this.totalCount = totalCount;
        this.branches = branches;
    }

    private CommitBranches(Builder builder) {
        this(builder.totalCount, (List<BaseBranch>)builder.branches.build());
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    @Nonnull
    public List<BaseBranch> getBranches() {
        return CommitBranches.nonNullList(this.branches);
    }

    public static class Builder
    extends Json.AbstractBuilder<Builder> {
        private final int totalCount;
        private final ImmutableList.Builder<BaseBranch> branches = ImmutableList.builder();

        public Builder(int totalCount) {
            this.totalCount = totalCount;
        }

        public Builder addBranches(Iterable<BaseBranch> branches) {
            this.branches.addAll(branches);
            return this;
        }

        public CommitBranches build() {
            return new CommitBranches(this);
        }
    }
}

