/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.branch;

import com.atlassian.fusion.schema.detail.BaseRepository;
import com.atlassian.fusion.schema.detail.branch.RepositoryBranch;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class Repository
extends BaseRepository {
    @JsonProperty
    private List<RepositoryBranch> branches;

    private Repository() {
    }

    private Repository(Builder builder) {
        super(builder);
        this.branches = builder.branches.build();
    }

    public List<RepositoryBranch> getBranches() {
        return Repository.nonNullList(this.branches);
    }

    public static class Builder
    extends BaseRepository.AbstractBuilder<Builder> {
        private ImmutableList.Builder<RepositoryBranch> branches = ImmutableList.builder();

        @Deprecated
        public Builder() {
            super(null);
        }

        public Builder(String name) {
            super(name);
        }

        public Builder addBranch(RepositoryBranch branch) {
            this.branches.add((Object)branch);
            return this;
        }

        public Builder addBranches(Iterable<RepositoryBranch> values) {
            this.branches.addAll(values);
            return this;
        }

        public Repository build() {
            return new Repository(this);
        }
    }
}

