(function($, Brace) {


JIRA.Auditing.SettingsView = Brace.View.extend({

    el: ".auditing-settings",

    templates: {
        settings: JIRA.Templates.Auditing.settings,
        throbber: JIRA.Templates.Auditing.throbber,
        error: JIRA.Templates.Auditing.error
    },

    events : {
        'click #auditing-settings-toggle' : 'toggleEnabled'
    },

    initialize: function() {
        this.$el.html(this.templates.throbber());
        this.model.on('sync', this.render, this);
        this.model.on('request', function() {
            this.$el.children(".loading").html(this.templates.throbber())
        }, this);
        this.model.on('error', function() {
            this.$el.html(this.templates.error());
        }, this);
    },

    render: function () {
        var isEnabled = this.model.get("enabled");
        this.$el.html(this.templates.settings({ enabled: isEnabled }));
        this.toggleLabels(isEnabled);
    },

    toggleEnabled: function () {
        var isEnabled = this.model.get("enabled");
        this.trigger("auditing:toggle-settings", {isEnabled: isEnabled})
    },

    toggleLabels: function(isEnabled) {
        if (isEnabled) {
            $("#auditing-settings-toggle").text(AJS.I18n.getText('admin.common.words.disable'));
            $(".auditing-status-message").text(AJS.I18n.getText('jap.auditing.message.enabled'));
        } else {
            $("#auditing-settings-toggle").text(AJS.I18n.getText('admin.common.words.enable'));
            $(".auditing-status-message").text(AJS.I18n.getText('jap.auditing.message.disabled'));
        }
    }

});

}(jQuery, Brace));
