(function($, Brace) {

    JIRA.Auditing.PaginationView = Brace.View.extend({

        events: {
            'click a.icon-next': 'nextResultPage',
            'click a.icon-previous': 'previousResultPage',
            'click a.page': 'goToPage',
            'click a.first': 'goToFirst'
        },

        template: JIRA.Templates.Auditing.pagination,

        initialize: function () {
            var info = this.collection.info() || {};
            info.size = this.collection.size();
            this.$el.html(this.template(info));
            $('a[title]', this.$el).tooltip();
        },

        stop: function () {
            $('a[original-title]', this.$el).each(function() {
                var $tooltip = $(this).data('tipsy');
                if ($tooltip) {
                    $tooltip.disable();
                    $tooltip.hide();
                }
            });
            this.undelegateEvents()
        },

        nextResultPage: function (e) {
            e.preventDefault();
            if (this.collection.info().next !== false) {
                this.collection.requestNextPage();
            }
        },

        previousResultPage: function (e) {
            e.preventDefault();
            if (this.collection.info().previous !== false) {
                this.collection.requestPreviousPage();
            }
        },

        goToFirst: function (e) {
            e.preventDefault();
            this.collection.goTo(this.collection.information.firstPage);
        },

        goToPage: function (e) {
            e.preventDefault();
            this.collection.goTo($(e.target).text());
        }

    });

}(jQuery, Brace));