(function ($, Paginator) {

    JIRA.Auditing.Record = Brace.Model.extend({

        namedAttributes: [
            'id',
            'summary',
            'author',
            'gmtOffset',
            'timezone',
            'created',
            'category',
            'remoteAddr',
            'objectItem',
            'changedValues',
            'associatedItems'],


        defaults: {
            summary: "",
            author: {
                fullName: ""
            },
            gmtOffset: "0",
            timezone: "",
            id: "",
            created: "",
            category: "",
            remoteAddr: "",
            objectItem: {
                objectName: ""
            },
            changedValues: [],
            associatedItems: []
        }
    });

    JIRA.Auditing.Records = Paginator.requestPager.extend({
        model: JIRA.Auditing.Record,

        // going to remember the first record we saw when loading the page so pagination doesn't change when new events are added
        // later we're going to add a pop up letting the user know it's time to refresh the page because new records were added
        topId: undefined,
        filter: "",
        //this goes as POST params, this is a workaround to make them empty instead of "null" or "undefined"
        timeUnit: "",
        timeUnitValue: "",
        fromDate: "",
        toDate: "",

        comparator: function descendingIdComparator (a, b){
            return parseInt(b.get("id")) - parseInt(a.get("id"))
        },

        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: AJS.contextPath() + "/rest/jira-auditing-plugin/1/view"
        },

        paginator_ui: {
            firstPage: 1,
            perPage: null,
            pagesInRange: 2
        },

        server_api: {
            'count': function() { return this.perPage },
            'maxId': function() {
                if (this.topId !== undefined) {
                    return this.topId;
                } else {
                    return "";
                }
            },
            'page': function() { return this.currentPage },
            'filter': function() { return this.filter },
            'timeUnit' : function() { return this.timeUnit },
            'timeUnitValue' : function() { return this.timeUnitValue },
            'fromDate' : function() { return this.fromDate },
            'toDate' : function() { return this.toDate }
        },


        search : function() {
            this.topId = undefined;
            this.goTo(this.information.firstPage);
        },

        parse : function(response) {
            this.totalRecords = response.count;
            if (this.topId === undefined && response.records.length > 0) {
                this.topId = response.records[0].id;
            }
            return response.records;
        },

        xhr : null,
        requestCount: 0,

        sync: function(method, model, options) {
            var requestNum = ++this.requestCount;
            if(this.xhr) {
                //since we are interested in results of only the latest query we can abort pending query
                this.xhr.abort();
            }
            options.success = this.getCallback(options.success, requestNum);
            options.error = this.getCallback(options.error, requestNum);
            this.xhr = Paginator.requestPager.prototype.sync.call(this, method, model, options);
        },

        //it wraps callback in if statement that checks whether it is response to latest query if not we can
        //discard this result
        getCallback : function(callback, requestNum) {
            var self = this;
            return function(model, resp, options) {
                if(self.requestCount === requestNum) {
                    self.xhr = null;
                    callback(model, resp, options)
                }
            };
        }

    });

}(jQuery, Backbone.Paginator));
