(function ($) {

    JIRA.Auditing.RecordsAnalytics = function() {

        return {

            search: false,
            collection: null,
            filter: null,
            previousCount: null,

            init: function(collection, filter) {
                this.collection = collection;
                this.filter = filter;
                this.collection.on('sync', this.sync, this);
                this.previousCount = this.collection.totalRecords;
            },

            searchStarted: function() {
                this.search = true;
            },

            sync: function() {
                try {
                if(this.search) {
                    var recordsReturned = this.collection.totalRecords;
                    var previousRecordsReturned = this.previousCount;
                    var letterCount = this.collection.filter.length;
                    var wordCount = _.filter(this.collection.filter.split(' '), function(word) {return word !== ""}).length;
                    var matchedFields = this.matchedFields(this.collection);
                    var timeType = this.filter.type;
                    var timeSecondsFrom;
                    var timeSecondsTo;
                    if (timeType === 'wtl') {
                        var timeUnit = this.filter.unit;
                        switch (timeUnit)
                        {
                            case "min":
                                timeSecondsFrom = this.filter.unitValue * 60;
                                break;
                            case "hrs":
                                timeSecondsFrom = this.filter.unitValue * 60 * 60;
                                break;
                            case "day":
                                timeSecondsFrom = this.filter.unitValue * 24 * 60 * 60;
                                break;
                            case "week":
                                timeSecondsFrom = this.filter.unitValue * 7 * 24 * 60 * 60;
                                break;
                        }
                        timeSecondsTo = 0;
                    }
                    if (timeType === 'btw') {
                        timeSecondsFrom = Math.round((new Date() - new Date(this.filter.fromDate)) / 1000);
                        timeSecondsTo = Math.round((new Date() - new Date(this.filter.toDate)) / 1000);
                    }
                    AJS.trigger('analyticsEvent', {name: 'administration.auditing.view.search', data: {
                        recordsReturned: recordsReturned,
                        previousRecordsReturned: previousRecordsReturned,
                        letterCount: letterCount,
                        wordCount: wordCount,
                        matchedFields: matchedFields,
                        timeUnit: timeUnit,
                        timeType: timeType,
                        timeSecondsFrom: timeSecondsFrom,
                        timeSecondsTo: timeSecondsTo
                    }});
                    this.previousCount = this.collection.totalRecords;
                }
                } catch (e) {
                    console.log(e);
                } finally {
                    this.search = false;
                }
            },

            matchedFields: function (records) {
                var words = this.collection.filter.split(' ');
                var lowerCaseWords = _.map(_.filter(words, function(word) {return word !== ""}), function(word){return word.toLowerCase()});
                var matchedFields = {};

                function isMatching(record, key, word, matchedFields2) {
                    if (record[key].toLowerCase().indexOf(word) != -1) {
                        matchedFields2[key] = null;
                    }
                }

                function fix(word) {
                    if (word === undefined) {
                        return "";
                    } else {
                        return word;
                    }
                }

                records.each(function(record) {
                    //prepare view of record
                    var transformedRecord = {};
                    transformedRecord['summary'] = fix(record.get('summary'));
                    transformedRecord['category'] = fix(record.get('category'));
                    transformedRecord['remoteAddr'] = fix(record.get('remoteAddr'));
                    transformedRecord['author'] = fix(record.get('author')['fullName']) + " " + fix(record.get('author')['username']);
                    transformedRecord['object'] = fix(record.get('objectItem')['objectName']) + " " + fix(record.get('objectItem')['parentName']);
                    transformedRecord['associatedItems'] = _.reduce(record.get('associatedItems'), function (memo, item) {
                        return memo + " " + fix(item["objectName"]) + " " + fix(item["parentName"]);
                    }, "");
                    transformedRecord['changedValues'] = _.reduce(record.get('changedValues'), function (memo, item) {
                        return memo + " " + fix(item["from"]) + " " + fix(item["to"]);
                    }, "");

                    //find matched fields in view
                    (function(record) {
                        _.each(lowerCaseWords, function(word) {
                            _.each(_.keys(record), function(key){
                                isMatching(record, key  , word, matchedFields);
                            });
                        });
                    }(transformedRecord));
                });
                return  _.reduce(_.keys(matchedFields), function (memo, field) {
                    return memo + field + ","
                }, "");
            }
        }
    };
}(jQuery));
