/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.scheme;

import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeMultiInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeTypes;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SchemeProjectRoleInspector
implements SchemeMultiInspector {
    private final ProjectRoleManager projectRoleManager;
    private final String type;

    public SchemeProjectRoleInspector(ProjectRoleManager projectRoleManager, String type) {
        this.projectRoleManager = projectRoleManager;
        this.type = type;
    }

    @Override
    public Iterable<InspectionNote> inspect(Iterable<SchemeEntity> entities, InspectionContext context) {
        ArrayList notes = Lists.newArrayList();
        List<ProjectRole> projectRoles = this.getProjectRoles(entities);
        if (projectRoles.isEmpty()) {
            return Collections.emptyList();
        }
        if (context.isAnonymous()) {
            if (context.isAnonymous()) {
                notes.add(InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.anonymous.cannot.meet")).build());
            }
        } else {
            List<ProjectRole> projectRolesUserIsIn = this.getProjectRolesUserIsIn(context, projectRoles);
            if (!projectRolesUserIsIn.isEmpty()) {
                List<String> projectRoleNames = this.getProjectRoleNames(projectRolesUserIsIn);
                notes.add(InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.projectrole.ok." + (projectRoleNames.size() > 1 ? "plural" : "singular")).addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(StringUtils.join(projectRoleNames, (String)", ")).build()).build());
            } else {
                List<String> projectRoleNames = this.getProjectRoleNames(projectRoles);
                notes.add(InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.projectrole.problem." + (projectRoleNames.size() > 1 ? "plural" : "singular")).addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(StringUtils.join(projectRoleNames, (String)", ")).build()).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.projectrole.problem.fix").newI18nLinkParameter().pathKey("whereismycf.inspection.link.projectpeople").urlParams(context.project().getKey()).textKey("permissionhelper.inspection.viewissue.projectrole.problem.linktext.projectroles").textParams(context.project().getName()).add().addPlainParameter(UserHelper.getDisplayName(context)).build()).build());
            }
        }
        return notes;
    }

    private List<ProjectRole> getProjectRoles(Iterable<SchemeEntity> entities) {
        ArrayList projectRoles = Lists.newArrayList();
        for (SchemeEntity schemeEntity : Iterables.filter(entities, SchemeTypes.isOfType(this.type))) {
            Long projectRoleId = Long.parseLong(schemeEntity.getParameter());
            ProjectRole projectRole = this.projectRoleManager.getProjectRole(projectRoleId);
            projectRoles.add(projectRole);
        }
        return projectRoles;
    }

    private List<String> getProjectRoleNames(List<ProjectRole> projectRoles) {
        ArrayList names = Lists.newArrayListWithCapacity((int)projectRoles.size());
        for (ProjectRole projectRole : projectRoles) {
            names.add(projectRole.getName());
        }
        return names;
    }

    private List<ProjectRole> getProjectRolesUserIsIn(InspectionContext context, List<ProjectRole> projectRoles) {
        ArrayList result = Lists.newArrayListWithCapacity((int)projectRoles.size());
        for (ProjectRole projectRole : projectRoles) {
            if (!this.projectRoleManager.isUserInProjectRole(context.user(), projectRole, context.project())) continue;
            result.add(projectRole);
        }
        return result;
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.projectrole.summary");
    }
}

