/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.customfieldhelper.versions.JiraVersionChecker;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;

public abstract class AbstractVersionsSystemFieldInspector<F extends Field>
extends AbstractFieldInspector<F> {
    private static final int[] JIRA_5_1 = new int[]{5, 1};
    private final JiraVersionChecker jiraVersionChecker;

    protected AbstractVersionsSystemFieldInspector(Class<F> fieldType, JiraVersionChecker jiraVersionChecker) {
        super(fieldType);
        this.jiraVersionChecker = jiraVersionChecker;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(Field field, FieldInspectionContext context) {
        if (context.issueOperation() == IssueOperations.VIEW_ISSUE_OPERATION && this.jiraVersionChecker.isEqualOrLaterThan(JIRA_5_1)) {
            if (context.project().getVersions().isEmpty()) {
                return ImmutableList.of((Object)this.createProblemNote(field, context));
            }
            return ImmutableList.of((Object)this.createOkNote(context));
        }
        return Collections.emptyList();
    }

    private InspectionNote createOkNote(FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(AbstractVersionsSystemFieldInspector.summary(context)).addDetails(this.createOkDetails(context)).build();
    }

    private InspectionNote createProblemNote(Field field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(AbstractVersionsSystemFieldInspector.summary(context)).addDetails(this.createProblemDetails(field, context)).build();
    }

    private static InspectionMessage summary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.versions.view.summary").build();
    }

    private InspectionMessage createOkDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.versions.view.ok").addPlainParameter(context.project().getName()).build();
    }

    private InspectionMessage createProblemDetails(Field field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.versions.view.problem").addPlainParameter(field.getName()).addPlainParameter(context.project().getName()).addNewLine().addLinkParameterFromI18n("whereismycf.inspection.versions.view.problem.linktext.projectversions", "whereismycf.inspection.link.projectversions", context.project().getKey()).build();
    }
}

