(function($) {

    var LABEL = AJS.I18n.getText('permissionhelper.dialog.title');

    JIRA.PermissionHelper.dialog = new JIRA.PermissionHelper.PermissionHelperDialog;
    $(document).delegate(".permissionhelper-trigger", "click", function(event) {
        event.preventDefault();
        AJS.trigger('analyticsEvent', {name: 'adminhelper.permhelper.dialog.open'});
        JIRA.PermissionHelper.dialog.show(createViewContext());
    });

    $(function () {
        var adminPageContainer = $("#permission-helper-admin-page");
        if (adminPageContainer.length == 1) {
            // Add page header
            addTitleToAdminPage();
            AJS.trigger('analyticsEvent', {name: 'adminhelper.permhelper.adminpage.open'});

            // Add page contents
            adminPageContainer.append($(JIRA.Templates.Dialogs.PermissionHelper.searchPage({
                noCloseLink: true,
                permissionGroups: JIRA.PermissionHelper.PERMISSIONS
            })));
            adminPageContainer.trigger(JIRA.Events.NEW_CONTENT_ADDED, [adminPageContainer]);
            JIRA.PermissionHelper.PermissionHelperUi.initUi(adminPageContainer, new JIRA.PermissionHelper.Context());

            $("#permissionhelper-user-field").focus();
        }
    });


    function createViewContext() {
        var issueKey = JIRA.Issue.getIssueKey();
        if (!issueKey && JIRA.IssueNavigator) {
            issueKey = JIRA.IssueNavigator.getSelectedIssueKey();
        }
        return new JIRA.PermissionHelper.Context({
            issueKey: issueKey,
            issueOperation: JIRA.PermissionHelper.dialog.OPERATION_VIEW
        });
    }

    function addTitleToAdminPage() {
        var $page = $('#permission-helper-admin-page');
        $page.prepend($("<h2>")
                .attr("id", "admin-page-heading")
                .text(LABEL));
    }

})(AJS.$);
