AJS.namespace("JIRA.NotificationHelper");

JIRA.NotificationHelper.NOTIFICATION_EVENTS = NOTIFICATION_EVENTS_SUBSTITUTION;

JIRA.NotificationHelper.defaultEventId = function() {
    var defaultId;
    AJS.$(JIRA.NotificationHelper.NOTIFICATION_EVENTS).each(function() {
        if (this.isDefault) {
            defaultId = this.id;
        }
    });
    return defaultId;
};

JIRA.NotificationHelper.NotificationHelperUi = {

    initUi: function ($content, notificationContext, onContentAdded) {

        initSingleSelects();

        var result = {};

        result.searchButton = $content.find("input.search");
        result.searchForm = $content.find("form.notificationhelper-search-form");
        var searcher = function(e) {
            e.preventDefault();

            var requestData = getRequestData($content,notificationContext);
            // Clear existing errors
            $content.find(".error").remove();
            // Check for errors
            var hasErrors = false;
            if (!requestData.params().username) {
                // No user provided
                addFieldError(AJS.$("#notificationhelper-user", $content), AJS.I18n.getText("adminhelper.dialog.notification.user.missing"));
                hasErrors = true;
            }
            if (!requestData.params().issueKey) {
                // No issue key provided
                addFieldError(AJS.$("#notificationhelper-issue", $content), AJS.I18n.getText("permissionhelper.dialog.issue.missing"));
                hasErrors = true;
            }
            if (!requestData.params().eventId) {
                // No event ID provided
                addFieldError(AJS.$("#notificationhelper-event", $content), AJS.I18n.getText("adminhelper.dialog.notification.event.missing"));
                hasErrors = true;
            }
            if (hasErrors) {
                return;
            }

            $content.find("#error-message-placeholder").empty();
            $content.find(".field-status-results").remove();
            $content.find(".field-status-placeholder").append(AJS.$(JIRA.Templates.AdminHelper.Common.loadingStatus()));
            AJS.trigger('analyticsEvent', {name: 'adminhelper.notihelper.check', data: {eventId: requestData.params().eventId}});
            JIRA.SmartAjax.makeRequest({
                url: contextPath + AJS.format("/rest/whereismycf/1.0/notifications?username={0}&issueKey={1}&eventId={2}",
                    requestData.params().username, requestData.params().issueKey, requestData.params().eventId),
                complete: function(xhr, textStatus, smartAjaxResult) {
                    // remove the loading status
                    $content.find(".status-loading").remove();
                    if (smartAjaxResult.successful) {
                        // TODO may need to reset the dropdown fields
                        // instance.queryControl.$field.val("").css("color", "black");
                        var notificationInfo = smartAjaxResult.data;
                        var statusLines = processStatusLines(notificationInfo.statusLines);
                        var $results = AJS.$(JIRA.Templates.Dialogs.NotificationHelper.resultPage({
                            eventName: notificationInfo.eventName,
                            username: notificationInfo.username,
                            userDisplayName: notificationInfo.userDisplayName,
                            userNotifyOwnChanges: notificationInfo.userNotifyOwnChanges,
                            issueKey: notificationInfo.issueKey,
                            projectKey: notificationInfo.projectKey,
                            projectName: notificationInfo.projectName,
                            status: notificationInfo.status,
                            statusLines: statusLines,
                            notificationSchemeName: notificationInfo.notificationSchemeName,
                            hideFailedStatuses: hasAtLeastOneGreenStatus(statusLines),
                            allFailedStatuses: !hasAtLeastOneGreenStatus(statusLines),
                            allGreenStatuses: allGreenStatuses(statusLines),
                            baseUrl: contextPath
                        }));
                        $content.find(".field-status-placeholder").append($results);
                        if (onContentAdded) {
                            onContentAdded();
                        }
                        $results.delegate(".show-failed-conditions", "click", function(e) {
                            e.preventDefault();
                            AJS.$(".statusRow[data-status='red']").show();
                            AJS.$(".show-failed-conditions").hide();
                            AJS.$(".hide-failed-conditions").show();
                            if (onContentAdded) {
                                onContentAdded();
                            }
                        });

                        $results.delegate(".hide-failed-conditions", "click", function(e) {
                            e.preventDefault();
                            AJS.$(".statusRow[data-status='red']").hide();
                            AJS.$(".hide-failed-conditions").hide();
                            AJS.$(".show-failed-conditions").show();
                            if (onContentAdded) {
                                onContentAdded();
                            }
                        });
                    } else {
                        handleError($content, smartAjaxResult);
                    }
                }
            });
        };
        result.searchForm.submit(searcher);
        result.searchButton.click(searcher);

        function addFieldError($field, errorMsg) {
            $field.parent().append(AJS.$("<div>")
                .addClass("error")
                .text(errorMsg));
        }

        function getRequestData($content, context) {
            return {
                eventId: function() {
                    var evenId = $content.find("#notificationhelper-event option:selected");
                    if (eventId.length > 0) {
                        return evenId.val();
                    } else {
                        return JIRA.NotificationHelper.defaultEventId();
                    }
                },

                paramsForRequest: function() {
                    return context.asRequestParams(this._paramsFromContents());
                },

                params: function() {
                    return context.params(this._paramsFromContents());
                },

                _paramsFromContents: function() {
                    var fromContents = {};
                    var selectedUser = $content.find("#notificationhelper-user option:selected");
                    if (selectedUser.length == 1) {
                        fromContents.username = selectedUser.val();
                    }
                    var issueKey = $content.find("#notificationhelper-issue option:selected");
                    if (issueKey.length > 0) {
                        fromContents.issueKey = issueKey.val();
                    }
                    var eventId = $content.find("#notificationhelper-event option:selected");
                    if (eventId.length > 0) {
                        fromContents.eventId = eventId.val();
                    }
                    return fromContents;
                }

            }
        }

        function processStatusLines(statusLines) {
            if (statusLines.length == 0) {
                return statusLines;
            }

            function processMessages(messages) {
                var processedMsgs = [];
                AJS.$.each(messages, function(index, message) {
                    processedMsgs.push(processMessage(message));
                });
                return processedMsgs;
            }

            function processMessage(message) {
                if (message.parameters.length == 0) {
                    return AJS.escapeHTML(message.message);
                } else {
                    var args = processParams(message.parameters);
                    // need to call AJS.format using apply cause all we have is an array of arguments
                    args.splice(0,0,AJS.escapeHTML(message.message));
                    return AJS.format.apply(this,args);
                }
            }

            function processParams(params) {
                var result = [];
                AJS.$.each(params, function(index, param) {
                    if (param.type=="plain") {
                        result.push(AJS.escapeHTML(param.value));
                    } else if (param.type=="link") {
                        result.push(AJS.format("<a href=''{0}'' target=''_blank''>{1}</a>", AJS.escapeHTML(param.href), AJS.escapeHTML(param.text)));
                    } else if (param.type=="newline") {
                        result.push("<br/>");
                    } else if (param.type=="tagstart") {
                        result.push("<" + param.tagName + ">");
                    } else if (param.type=="tagend") {
                        result.push("</" + param.tagName + ">");
                    } else {
                        throw "Unrecognized parameter type: " + param.type;
                    }
                });
                return result;
            }

            var processed = [];
            AJS.$.each(statusLines, function(index, statusLine) {
                var newStatus = {};
                newStatus.status = statusLine.status;
                newStatus.summary = processMessages(statusLine.summary);
                newStatus.details = processMessages(statusLine.details);
                processed.push(newStatus);
            });
            return processed;
        }

        function hasAtLeastOneGreenStatus(statusLines) {
            var hasGreen = false;
            AJS.$.each(statusLines, function(index, statusLine) {
                if (statusLine.status == "green") {
                    hasGreen = true;
                    return false;
                }
            });
            return hasGreen;
        }

        function allGreenStatuses(statusLines) {
            var red = false;
            AJS.$.each(statusLines, function(index, statusLine) {
                if (statusLine.status == "red") {
                    red = true;
                }
            });
            return !red;
        }

        function handleError($contents, smartAjaxResult) {
            var errorsShown = false;
            var errorMessages = [];
            if (smartAjaxResult.data) {
                var data = JSON.parse(smartAjaxResult.data);
                if (data.errorMessages && data.errorMessages.length) {
                    errorMessages.push(data.errorMessages);
                    errorsShown = true;
                }
                if (data.errors) {
                    if (data.errors.issue) {
                        addFieldError(AJS.$("#notificationhelper-issue", $contents), data.errors.issue);
                        errorsShown = true;
                    }
                    if (data.errors.user) {
                        addFieldError(AJS.$("#notificationhelper-user", $contents), data.errors.user);
                        errorsShown = true;
                    }
                    if (data.errors.event) {
                        addFieldError(AJS.$("#notificationhelper-event", $contents), data.errors.event);
                        errorsShown = true;
                    }
                }
            }
            if (!errorsShown) {
                errorMessages.push(JIRA.SmartAjax.buildSimpleErrorContent(smartAjaxResult));
            }
            var $placeholder = result.searchForm.find("#error-message-placeholder");
            AJS.$.each(errorMessages, function(index, message) {
                AJS.messages.error($placeholder, {
                    body: message,
                    closeable: false
                });
            });
        }

        function initSingleSelects() {

            new JIRA.AdminHelper.IssuePicker({
                element: AJS.$("#notificationhelper-issue"),
                itemAttrDisplayed: "label",
                width: 500
            });

            new AJS.SingleSelect({
                element: AJS.$("#notificationhelper-event"),
                itemAttrDisplayed: "label", // show full text, not value, in lozenges. (e.g "Oyster Bay" instead of "5")
                width: 500
            });
        }

        return result;
    }
};



