(function($) {

    $(function () {
        if (isOnEditNotificationsPage()) {
            var $header = getHeaderOnEditNotificationsPage();
            $header.append($(JIRA.Templates.Nav.NotificationHelper.editNotificationsNavButton()));
            showHelpTip(AJS.$("#notification-helper-button"));
        }
        else if (isOnViewNotificationsPage()) {
            var $opMenu = getOperationMenuOnViewNotificationsPage();
            // operations menu may be hidden
            if ($opMenu.length == 1) {
                $opMenu.prepend($(JIRA.Templates.Nav.NotificationHelper.viewNotificationsNavButton()));
                showHelpTip(AJS.$("#notification-helper-button"));
            }
        }
    });

    function isOnEditNotificationsPage() {
        var $el = $("#notificationSchemeTable");
        return ($el.length >= 1);
    }

    function isOnViewNotificationsPage() {
        var $el = $("#project-config-notifications-table");
        return ($el.length >= 1);
    }

    function getHeaderOnEditNotificationsPage() {
        var $header = $(".content-body > header");
        if ($header.length == 0) {
            $header = $("<header>");
            $(".content-body").prepend($header);
        }
        return $header;
    }

    function getOperationMenuOnViewNotificationsPage() {
        if (AJS.DarkFeatures.isEnabled('com.atlassian.jira.config.PDL')) {
            var pageActionsContainer = $("#project-config-panel-notifications > .aui-page-header .aui-page-header-actions");
            var existingButtons = pageActionsContainer.find(".aui-buttons");
            return (existingButtons.size() > 0) ? existingButtons : pageActionsContainer;
        }
        return $(".project-config-panel-header > .operation-menu");
    }

    function showHelpTip($anchor) {
        if (AJS.HelpTip) {
            var helpTip = new AJS.HelpTip({
                id: 'notification-helper-helptip',
                title: AJS.I18n.getText('notificationhelper.nav.helptip.title'),
                body: AJS.I18n.getText('notificationhelper.nav.helptip.body'),
                anchor: $anchor
            });
            helpTip.show();

            $('#notification-helper-helptip').click(function() {
                helpTip.dismiss();
            });
            $anchor.click(function() {
                helpTip.dismiss();
            })
        }
    }
    
})(AJS.$);
