/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestExceptionFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestValidationHelper {
    private final UserManager userManager;
    private final IssueManager issueManager;
    private final InvalidRequestExceptionFactory exceptionFactory;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public RestValidationHelper(UserManager userManager, IssueManager issueManager, InvalidRequestExceptionFactory exceptionFactory, JiraAuthenticationContext authenticationContext) {
        this.userManager = userManager;
        this.issueManager = issueManager;
        this.exceptionFactory = exceptionFactory;
        this.authenticationContext = authenticationContext;
    }

    public User validateInspectedUser(String username) {
        User user = this.userManager.getUser(username);
        if (user != null && !user.isActive()) {
            throw this.exceptionFactory.failedWithFieldError(Response.Status.BAD_REQUEST, "user", this.getI18n().getText("whereismycf.error.user.not.active", username));
        }
        if (!StringUtils.isBlank((String)username) && user == null) {
            throw this.exceptionFactory.failedWithFieldError(Response.Status.BAD_REQUEST, "user", this.getI18n().getText("whereismycf.error.user.not.known", username));
        }
        return user;
    }

    public Issue validateIssue(String issueKey) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue == null) {
            throw this.exceptionFactory.failedWithFieldError(Response.Status.BAD_REQUEST, "issue", this.getI18n().getText("whereismycf.error.issuenotfound", issueKey));
        }
        return issue;
    }

    public I18nHelper getI18n() {
        return this.authenticationContext.getI18nHelper();
    }
}

