/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeGroupInspector;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionSchemeGroupInspector
implements ProjectPermissionInspector {
    private final PermissionSchemeManager permissionSchemeManager;
    private final SchemeGroupInspector schemeGroupInspector;

    @Autowired
    public PermissionSchemeGroupInspector(PermissionSchemeManager permissionSchemeManager, GroupManager groupManager, I18nResolver i18nResolver) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.schemeGroupInspector = new SchemeGroupInspector(groupManager, "group", i18nResolver);
    }

    @Override
    public Iterable<InspectionNote> inspect(PermissionInspectionContext context) {
        Project project = context.project();
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        List entities = permissionScheme.getEntitiesByType((Object)context.permission().getId());
        return this.schemeGroupInspector.inspect(entities, context);
    }
}

