/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.notification;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.NotificationInspectionContext;
import com.atlassian.jira.customfieldhelper.impl.inspector.notification.AbstractNotificationInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeTypes;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationAllWatchersInspector
extends AbstractNotificationInspector {
    private final IssueManager issueManager;
    private final AllWatchersSchemeInspector allWatchersSchemeInspector;

    @Autowired
    public NotificationAllWatchersInspector(NotificationSchemeManager notificationSchemeManager, IssueManager issueManager) {
        super(notificationSchemeManager);
        this.issueManager = issueManager;
        this.allWatchersSchemeInspector = new AllWatchersSchemeInspector();
    }

    @Override
    @Nonnull
    protected Iterable<InspectionNote> inspectEntities(@Nonnull Iterable<SchemeEntity> entities, @Nonnull NotificationInspectionContext context) {
        return SchemeTypes.forEach(entities, context, "All_Watchers", this.allWatchersSchemeInspector);
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "adminhelper.notification.inspection.allwatchers.summary");
    }

    private InspectionMessage okDetails(InspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("adminhelper.notification.inspection.allwatchers.ok").addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(context.issue().getKey()).build();
    }

    private InspectionMessage problemDetails(InspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("adminhelper.notification.inspection.allwatchers.problem").addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(context.issue().getKey()).build();
    }

    private class AllWatchersSchemeInspector
    implements SchemeInspector {
        private AllWatchersSchemeInspector() {
        }

        @Override
        public InspectionNote inspect(SchemeEntity schemeEntity, InspectionContext context) {
            Iterable watchers = Iterables.transform((Iterable)NotificationAllWatchersInspector.this.issueManager.getWatchers(context.issue()), (Function)new Function<User, String>(){

                public String apply(User user) {
                    return UserHelper.getUserKey(user);
                }
            });
            if (Iterables.contains((Iterable)watchers, (Object)UserHelper.getUserKey(context))) {
                return InspectionNote.ok(NotificationAllWatchersInspector.this.summary(context)).addDetails(NotificationAllWatchersInspector.this.okDetails(context)).build();
            }
            return InspectionNote.problem(NotificationAllWatchersInspector.this.summary(context)).addDetails(NotificationAllWatchersInspector.this.problemDetails(context)).build();
        }
    }
}

