define('jira/inline-issue-create/entities/widget-constants', [], function () {
    "use strict";

    var frozenObjectCanNotBeUnfrozenSoGTFO = {
        STATE_CLOSED: "STATE_CLOSED",
        STATE_ACTIVE: "STATE_ACTIVE",
        STATE_LOCK_TEMP_INACTIVE: "STATE_LOCK_TEMP_INACTIVE",
        STATE_LOCK_SENDING: "STATE_LOCK_SENDING",
        STATE_LOCK_PERM_INACTIVE: "STATE_LOCK_PERM_INACTIVE",
        STATE_LOCK_UNLOCKED: "STATE_LOCK_UNLOCKED"
    };
    Object.freeze(frozenObjectCanNotBeUnfrozenSoGTFO); // IE8 is dead!
    return frozenObjectCanNotBeUnfrozenSoGTFO;
});

define('jira/inline-issue-create/entities/widget', [
    'jira/inline-issue-create/lib/brace',
    'jira/inline-issue-create/entities/issue-types',
    'jira/inline-issue-create/entities/issue-type',
    'jira/inline-issue-create/entities/widget-constants'
], function (
    Brace,
    IssueTypesCollection,
    IssueTypeModel,
    WidgetConstants
) {
    "use strict";

    var SELECTED_ISSUE_TYPE_STORAGE_KEY = "iic.slectedIssueType";

    var constants = WidgetConstants;

    var WidgetModel = Brace.Model.extend({

        constants: constants,

        defaults: {
            state: constants.STATE_CLOSED,
            lockState: constants.STATE_LOCK_UNLOCKED
        },

        namedAttributes: {
            "summary": "",
            "selectedIssueType": IssueTypeModel,
            "issueTypes": IssueTypesCollection,
            "state": "",
            "lastState": "",
            "lockState": ""
        },
        initialize: function initialize(attributes) {
            var previouslySelectedIssueTypeJSON;
            var previouslySelectedIssueType;

            if (!attributes || !attributes.selectedIssueType) {
                if (localStorage) {
                    previouslySelectedIssueTypeJSON = JSON.parse(localStorage.getItem(SELECTED_ISSUE_TYPE_STORAGE_KEY)) || {};
                    previouslySelectedIssueTypeJSON = previouslySelectedIssueTypeJSON || {};
                    previouslySelectedIssueType = this.getIssueTypes() && this.getIssueTypes().find(function findIssue(issueType) {
                        return issueType.getId() === previouslySelectedIssueTypeJSON.id;
                    });
                }

                if (previouslySelectedIssueType) {
                    this.setSelectedIssueType(previouslySelectedIssueType);
                } else if (this.getIssueTypes()) {
                    this.setSelectedIssueType(this.getIssueTypes().at(0));
                }
            }

            this.on("change:selectedIssueType", function onSelectedIssueTypeChange(e) {
                var selectedIssueType = this.getSelectedIssueType();
                if (selectedIssueType) {
                    localStorage.setItem(SELECTED_ISSUE_TYPE_STORAGE_KEY, JSON.stringify(selectedIssueType.toJSON()));
                }
            });

            this.listenTo(this.getIssueTypes(), "reset", function onIssueTypesReset() {
                var selectedIssueTypeId = this.getSelectedIssueType() && this.getSelectedIssueType().getId();
                var currentlySelectedIssueTypeInTheCollection;

                if (!selectedIssueTypeId) {
                    selectedIssueTypeId = previouslySelectedIssueTypeJSON.id;
                }

                if (selectedIssueTypeId !== undefined) {
                    currentlySelectedIssueTypeInTheCollection = this.getIssueTypes().get(selectedIssueTypeId);
                    if (currentlySelectedIssueTypeInTheCollection) {
                        // make sure we use the model from the collection, not the one potentially populated from localStorage
                        this.setSelectedIssueType(currentlySelectedIssueTypeInTheCollection);
                    } else {
                        this.setSelectedIssueType(this.getIssueTypes().at(0));
                    }
                } else {
                    this.setSelectedIssueType(this.getIssueTypes().at(0));
                }

            });
        },
        changeState: function changeState(newState) {
            if (newState === this.getState()) {
                return;
            }
            this.setLastState(this.getState());
            this.setState(newState);
        },
        setSelectedIssueTypeIfAvailable: function setSelectedIssueTypeIfAvailable(issueTypeToSelect) {
            if (issueTypeToSelect) {
                var newIssueType = this.getIssueTypes().get(issueTypeToSelect.getId());
                if (newIssueType) {
                    this.setSelectedIssueType(newIssueType);
                }
            }
        },
        toIssueData: function toIssueData() {
            return {
                summary: this.getSummary(),
                issueTypeId: this.getSelectedIssueType() && this.getSelectedIssueType().getId()
            };
        }
    });

    return WidgetModel;
});

