/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBundle;
import com.atlassian.jira.plugins.inform.events.listener.JiraEventListener;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class IssueEventListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final JiraEventListener delegateListener;

    @Autowired
    public IssueEventListener(@ComponentImport EventPublisher eventPublisher, @Qualifier(value="asyncJiraEventListener") JiraEventListener delegateListener) {
        this.eventPublisher = eventPublisher;
        this.delegateListener = delegateListener;
    }

    @EventListener
    public void handleIssueEventBundle(OnCommitIssueEventBundle bundle) {
        this.delegateListener.handleIssueEventBundle(bundle);
    }

    @EventListener
    public void handleIssueEvent(OnCommitIssueEvent issueEvent) {
        this.delegateListener.handleIssueEvent(issueEvent);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

