/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.convert;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.mail.TemplateIssue;
import com.atlassian.jira.mail.TemplateIssueFactory;
import com.atlassian.jira.plugins.inform.api.events.IssueEventParameter;
import com.atlassian.jira.plugins.inform.api.events.Parameter;
import com.atlassian.jira.plugins.inform.api.events.convert.ChangeItem;
import com.atlassian.jira.plugins.inform.api.events.convert.ParameterConverter;
import com.atlassian.jira.plugins.inform.api.events.convert.parameters.DbStorageUtil;
import com.atlassian.jira.plugins.inform.api.events.convert.parameters.ObjectTypes;
import com.atlassian.jira.plugins.inform.api.events.dto.ParameterDTO;
import com.atlassian.jira.plugins.inform.events.convert.render.DefaultFieldRenderer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectConstant;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.jackson.map.ObjectMapper;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

public class ParameterConverters {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterConverter.class);

    private ParameterConverters() {
    }

    private static Long getEffectiveEventType(IssueEvent event, EventTypeManager eventTypeManager) {
        if (event == null || eventTypeManager == null) {
            return null;
        }
        Long templateId = Optional.ofNullable(eventTypeManager.getEventType(event.getEventTypeId())).map(EventType::getTemplateId).orElse(null);
        if (templateId != null) {
            return templateId;
        }
        return event.getEventTypeId();
    }

    static class EntityParameterConverter<T> {
        private final Function<Long, T> idToEntity;

        EntityParameterConverter(Function<Long, T> idToEntity) {
            this.idToEntity = idToEntity;
        }

        Set<T> convertTo(Stream<Parameter> params) {
            return params.map(Parameter::getValue).distinct().flatMap(EntityParameterConverter::parseLong).map(this.idToEntity).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        static Stream<Long> parseLong(String s) {
            try {
                return Stream.of(Long.valueOf(Long.parseLong(s)));
            }
            catch (NumberFormatException e) {
                return Stream.of(new Long[0]);
            }
        }
    }

    @ExportAsService(value={EventParametersConverter.class})
    @Component
    @Order(value=700)
    public static class EventParametersConverter
    implements ParameterConverter<Map<String, String>> {
        private static final String NAME_ID = "JIRA_EVENT_PARAMETERS";
        public static final String EVENTSOURCE_KEY = "eventsource";
        public static final String TEMPLATE_ID_KEY = "templateId";
        private final EventTypeManager eventTypeManager;
        private ObjectMapper objectMapper;

        @Autowired
        EventParametersConverter(@ComponentImport @Nonnull EventTypeManager eventTypeManager) {
            this.eventTypeManager = Objects.requireNonNull(eventTypeManager);
            this.objectMapper = new ObjectMapper();
        }

        public Stream<Parameter> convertFrom(IssueEvent event) {
            String value = "";
            try {
                HashMap<String, String> parameters = new HashMap<String, String>();
                Object eventsource = event.getParams().get(EVENTSOURCE_KEY);
                parameters.put(EVENTSOURCE_KEY, Objects.toString(eventsource, null));
                parameters.put(TEMPLATE_ID_KEY, Optional.ofNullable(this.eventTypeManager.getEventType(event.getEventTypeId())).map(EventType::getTemplateId).map(Object::toString).orElse(null));
                value = this.objectMapper.writeValueAsString(parameters);
            }
            catch (Exception e) {
                LOG.warn("Exception during EventParameter serialize", (Throwable)e);
            }
            return Stream.of(new ParameterDTO(null, NAME_ID, value));
        }

        public Optional<Map<String, String>> convertTo(Stream<Parameter> params, ParameterConverter.Context context) {
            return params.filter(param -> NAME_ID.equals(param.getName())).map(param -> {
                try {
                    return (Map)this.objectMapper.readValue(param.getValue(), Map.class);
                }
                catch (Exception e) {
                    LOG.warn("Exception during EventParameter deserialize", (Throwable)e);
                    return Collections.emptyMap();
                }
            }).findFirst();
        }

        public static class EventParameters {
            @Nullable
            public static String getEventSource(@Nonnull Map<String, String> map) {
                return map.get(EventParametersConverter.EVENTSOURCE_KEY);
            }

            @Nullable
            public static Long getTemplateId(@Nonnull Map<String, String> map) {
                return Optional.ofNullable(map.get(EventParametersConverter.TEMPLATE_ID_KEY)).map(Long::new).orElse(null);
            }
        }
    }

    @Component
    @Order(value=600)
    public static class CommentParameterConverter
    implements ParameterConverter<Set<Comment>> {
        private static final String PROPERTY = "comment_id";
        private final EntityParameterConverter<Comment> delegate = new EntityParameterConverter<Comment>(arg_0 -> ((CommentManager)commentManager).getCommentById(arg_0));
        private final DefaultFieldRenderer fieldRenderer;

        @Autowired
        CommentParameterConverter(@ComponentImport CommentManager commentManager, DefaultFieldRenderer fieldRenderer) {
            this.fieldRenderer = fieldRenderer;
        }

        public Stream<Parameter> convertFrom(IssueEvent event) {
            Comment originalComment = (Comment)event.getParams().get("originalcomment");
            return Stream.concat(this.getParameters(event, event.getComment(), false), this.getParameters(event, originalComment, true));
        }

        private Stream<Parameter> getParameters(IssueEvent issueEvent, Comment comment, boolean before) {
            Stream.Builder<ParameterDTO> builder = Stream.builder();
            if (comment != null) {
                String body = comment.getBody();
                if (before && ((Boolean)IssueEventParameter.CLEAR_ENTITY_BEFORE_PARAMETER.get(issueEvent)).booleanValue()) {
                    body = null;
                }
                if (!before && ((Boolean)IssueEventParameter.SKIP_ENTITY_NEW_PARAMETER.get(issueEvent)).booleanValue()) {
                    return Stream.empty();
                }
                builder.add(new ParameterDTO(null, PROPERTY, comment.getId().toString()));
                builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.COMMENT), (String)(before ? "oldvalue" : "newvalue")), body));
                builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.COMMENT), (String)(before ? "oldstring" : "newstring")), this.fieldRenderer.render(issueEvent.getUser(), comment.getIssue(), "comment", body)));
                if (comment.getGroupLevel() != null) {
                    builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.COMMENT), (String)(before ? "grouplevel_before" : "grouplevel_after")), comment.getGroupLevel()));
                }
                if (comment.getRoleLevel() != null) {
                    builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.COMMENT), (String)(before ? "rolelevel_before" : "rolelevel_after")), comment.getRoleLevel().getName()));
                }
            }
            return builder.build();
        }

        public Optional<Set<Comment>> convertTo(Stream<Parameter> params, ParameterConverter.Context context) {
            return Optional.of(this.delegate.convertTo(params.filter(param -> PROPERTY.equals(param.getName()))));
        }
    }

    @Component
    @Order(value=500)
    public static class WorklogParameterConverter
    implements ParameterConverter<Set<Worklog>> {
        private static final String NAME_ID = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.WORKLOG), (String)"id");
        private final EntityParameterConverter<Worklog> delegate = new EntityParameterConverter<Worklog>(arg_0 -> ((WorklogManager)worklogManager).getById(arg_0));
        private final DefaultFieldRenderer fieldRenderer;

        @Autowired
        WorklogParameterConverter(@ComponentImport WorklogManager worklogManager, DefaultFieldRenderer fieldRenderer) {
            this.fieldRenderer = fieldRenderer;
        }

        public Stream<Parameter> convertFrom(IssueEvent event) {
            Worklog worklog = event.getWorklog();
            Worklog originalWorkLog = (Worklog)event.getParams().get("originalworklog");
            if (EventType.ISSUE_WORKLOG_DELETED_ID.equals(event.getEventTypeId())) {
                if (originalWorkLog == null && worklog != null) {
                    originalWorkLog = worklog;
                }
                worklog = null;
            }
            return Stream.concat(this.getParameters(event, worklog, false), this.getParameters(event, originalWorkLog, true));
        }

        private Stream<Parameter> getParameters(IssueEvent issueEvent, Worklog worklog, boolean before) {
            Stream.Builder<ParameterDTO> builder = Stream.builder();
            if (worklog == null) {
                return builder.build();
            }
            builder.add(new ParameterDTO(null, NAME_ID, String.valueOf(worklog.getId())));
            String worklogComment = worklog.getComment();
            if (before && ((Boolean)IssueEventParameter.CLEAR_ENTITY_BEFORE_PARAMETER.get(issueEvent)).booleanValue()) {
                worklogComment = null;
            }
            if (worklog.getTimeSpent() != null) {
                builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.WORKLOG_TIME_SPENT), (String)(before ? "oldvalue" : "newvalue")), worklog.getTimeSpent() + ""));
                builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.WORKLOG_TIME_SPENT), (String)(before ? "oldstring" : "newstring")), worklog.getTimeSpent() + ""));
            }
            if (worklog.getAuthorKey() != null) {
                builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.WORKLOG_AUTHOR), (String)(before ? "oldvalue" : "newvalue")), worklog.getAuthorKey() + ""));
                builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.WORKLOG_AUTHOR), (String)(before ? "oldstring" : "newstring")), worklog.getAuthorKey() + ""));
            }
            builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.WORKLOG_COMMENT), (String)(before ? "oldvalue" : "newvalue")), worklogComment));
            builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.WORKLOG_COMMENT), (String)(before ? "oldstring" : "newstring")), this.fieldRenderer.render(issueEvent.getUser(), worklog.getIssue(), "comment", worklogComment)));
            if (worklog.getGroupLevel() != null) {
                builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.WORKLOG_COMMENT), (String)(before ? "grouplevel_before" : "grouplevel_after")), worklog.getGroupLevel()));
            }
            if (worklog.getRoleLevel() != null) {
                builder.add(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.WORKLOG_COMMENT), (String)(before ? "rolelevel_before" : "rolelevel_after")), worklog.getRoleLevel().getName()));
            }
            return builder.build();
        }

        public Optional<Set<Worklog>> convertTo(Stream<Parameter> params, ParameterConverter.Context context) {
            return Optional.of(this.delegate.convertTo(params.filter(param -> NAME_ID.equals(param.getName()))));
        }
    }

    public static class ProjectView {
        private final String id;
        private final String name;
        private final Project project;

        public ProjectView(String id, String name, Project project) {
            this.id = id;
            this.name = name;
            this.project = project;
        }

        @Nullable
        public Project getProject() {
            return this.project;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public boolean isDeleted() {
            return this.project == null;
        }

        public Optional<Avatar> getAvatar() {
            return Optional.ofNullable(this.project).map(Project::getAvatar);
        }

        public Optional<String> getKey() {
            return Optional.ofNullable(this.project).map(Project::getKey);
        }
    }

    @ExportAsService(value={ProjectParameterConverter.class})
    @Component
    @Order(value=400)
    public static class ProjectParameterConverter
    implements ParameterConverter<ProjectView> {
        public static final String NAME_ID = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.PROJECT), (String)"id");
        public static final String NAME_NAME = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.PROJECT), (String)"name");
        public static final String NAME_EMAIL = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.PROJECT), (String)"email");
        public static final String NAME_FROM_NAME = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.PROJECT), (String)"from_name");
        private final ProjectManager projectManager;

        @Autowired
        public ProjectParameterConverter(@ComponentImport ProjectManager projectManager) {
            this.projectManager = projectManager;
        }

        public Stream<Parameter> convertFrom(IssueEvent event) {
            if (event.getIssue() != null && event.getIssue().getProjectObject() != null) {
                return Stream.of(new ParameterDTO(null, NAME_ID, String.valueOf(event.getProject().getId())), new ParameterDTO(null, NAME_NAME, event.getProject().getName()), new ParameterDTO(null, NAME_EMAIL, event.getProject().getEmail()), new ParameterDTO(null, NAME_FROM_NAME, JiraMailUtils.getFromNameForUser((ApplicationUser)event.getUser())));
            }
            return Stream.of(new Parameter[0]);
        }

        public Optional<ProjectView> convertTo(Stream<Parameter> params, ParameterConverter.Context context) {
            ProjectView project = params.reduce(new ProjectView(null, null, null), this::addParameter, (a, b) -> a);
            if (project.getName() != null) {
                return Optional.of(project);
            }
            return Optional.empty();
        }

        private ProjectView addParameter(ProjectView source, Parameter parameter) {
            if (NAME_ID.equals(parameter.getName())) {
                return ProjectParameterConverter.parseLong(parameter.getValue()).map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).map(p -> new ProjectView(parameter.getValue(), p.getName(), (Project)p)).orElse(source);
            }
            if (NAME_NAME.equals(parameter.getName())) {
                return new ProjectView(source.getId(), parameter.getValue(), source.getProject());
            }
            return source;
        }

        private static Optional<Long> parseLong(String s) {
            try {
                return Optional.of(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
    }

    @ExportAsService(value={ChangeItemParameterConverter.class})
    @Component
    @Order(value=300)
    public static class ChangeItemParameterConverter
    implements ParameterConverter<List<ChangeItem>> {
        private final EventTypeManager eventTypeManager;

        @Autowired
        public ChangeItemParameterConverter(@Nonnull EventTypeManager eventTypeManager) {
            this.eventTypeManager = Objects.requireNonNull(eventTypeManager);
        }

        public Stream<Parameter> convertFrom(IssueEvent event) {
            if (event.getChangeLog() != null && !Objects.equals(EventType.ISSUE_CREATED_ID, ParameterConverters.getEffectiveEventType(event, this.eventTypeManager))) {
                try {
                    AtomicInteger index = new AtomicInteger();
                    return event.getChangeLog().getRelated("ChildChangeItem").stream().flatMap(childChangeItem -> this.fromChangeItem((GenericValue)childChangeItem, index.getAndIncrement()));
                }
                catch (GenericEntityException e) {
                    return Stream.of(new Parameter[0]);
                }
            }
            return Stream.of(new Parameter[0]);
        }

        private Stream<Parameter> fromChangeItem(GenericValue changeItem, int index) {
            String fieldtype = changeItem.getString("fieldtype");
            String field = changeItem.getString("field");
            return Stream.of(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(new DbStorageUtil.ObjectType(fieldtype, field), index), (String)"oldvalue"), changeItem.getString("oldvalue")), new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(new DbStorageUtil.ObjectType(fieldtype, field), index), (String)"newvalue"), changeItem.getString("newvalue")), new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(new DbStorageUtil.ObjectType(fieldtype, field), index), (String)"oldstring"), changeItem.getString("oldstring")), new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(new DbStorageUtil.ObjectType(fieldtype, field), index), (String)"newstring"), changeItem.getString("newstring")));
        }

        public Optional<List<ChangeItem>> convertTo(Stream<Parameter> params, ParameterConverter.Context context) {
            DbStorageUtil.DbObjects dbObjects = DbStorageUtil.convert(params);
            Collection changeItems = dbObjects.get(dbObject -> "jira".equals(dbObject.getObjectTypeIndexed().getObjectType().getEntityType()) || "custom".equals(dbObject.getObjectTypeIndexed().getObjectType().getEntityType()));
            return Optional.of(changeItems.stream().map(ChangeItem::fromDbObject).collect(Collectors.toList()));
        }
    }

    @Component
    @Order(value=200)
    public static class IssueCreatedParameterConverter
    implements ParameterConverter<Void> {
        private static final Logger LOG = LoggerFactory.getLogger(IssueCreatedParameterConverter.class);
        private final TemplateIssueFactory templateIssueFactory;
        private final IssueSecurityLevelManager issueSecurityLevelManager;
        private final CustomFieldManager customFieldManager;
        private final DefaultFieldRenderer fieldRenderer;
        private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
        private final EventTypeManager eventTypeManager;

        @Autowired
        public IssueCreatedParameterConverter(@ComponentImport TemplateIssueFactory templateIssueFactory, @ComponentImport IssueSecurityLevelManager issueSecurityLevelManager, @ComponentImport CustomFieldManager customFieldManager, DefaultFieldRenderer fieldRenderer, @ComponentImport IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, @ComponentImport EventTypeManager eventTypeManager) {
            this.templateIssueFactory = templateIssueFactory;
            this.issueSecurityLevelManager = issueSecurityLevelManager;
            this.customFieldManager = customFieldManager;
            this.fieldRenderer = fieldRenderer;
            this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
            this.eventTypeManager = eventTypeManager;
        }

        public Stream<Parameter> convertFrom(IssueEvent event) {
            Issue issue = event.getIssue();
            if (issue != null && Objects.equals(EventType.ISSUE_CREATED_ID, ParameterConverters.getEffectiveEventType(event, this.eventTypeManager))) {
                Stream.Builder<Parameter> builder = Stream.builder();
                this.handleIssueConstant(issue, builder, "issuetype", (IssueConstant)issue.getIssueType());
                this.handleProjectConstantCollection(issue, builder, "Version", issue.getAffectedVersions());
                this.handleIssueUser(issue, builder, "assignee", issue.getAssignee());
                this.handleAttachments(issue, builder);
                this.handleProjectConstantCollection(issue, builder, "Component", issue.getComponents());
                this.handleTimestamp(issue, builder, "createddate", issue.getCreated());
                this.handleTimestamp(issue, builder, "duedate", issue.getDueDate());
                this.handleEnvironment(issue, builder);
                this.handleProjectConstantCollection(issue, builder, "Fix Version", issue.getFixVersions());
                this.handleLabels(issue, builder);
                this.handleIssueConstant(issue, builder, "priority", (IssueConstant)issue.getPriority());
                this.handleIssueUser(issue, builder, "reporter", issue.getReporter());
                this.handleSecurityLevel(issue, builder);
                this.handleTimeTracking(issue, builder);
                this.handleDescription(issue, builder);
                this.handleSummary(issue, builder);
                this.handleCustomFields(issue, builder);
                this.handleIssueConstant(issue, builder, "resolution", (IssueConstant)issue.getResolution());
                return builder.build();
            }
            return Stream.of(new Parameter[0]);
        }

        private void handleCustomFields(Issue issue, Stream.Builder<Parameter> builder) {
            try {
                Set<String> fieldIds = this.getFieldIdsFromCreateIssueScreen(issue);
                if (!fieldIds.isEmpty()) {
                    this.customFieldManager.getCustomFieldsWithValue(issue).stream().filter(cf -> fieldIds.contains(cf.getId())).map(cf -> Pair.of((Object)cf, (Object)cf.getCustomFieldType())).filter(pair -> pair.getRight() != null).forEach(pair -> this.addParameters(issue, (CustomField)pair.getLeft(), (CustomFieldType)pair.getRight(), ((CustomField)pair.getLeft()).getValue(issue), builder));
                }
            }
            catch (Exception e) {
                LOG.warn("Exception during custom field processing", (Throwable)e);
            }
        }

        private Set<String> getFieldIdsFromCreateIssueScreen(Issue issue) {
            return Optional.ofNullable(this.issueTypeScreenSchemeManager.getFieldScreenScheme(issue)).map(fieldScreenScheme -> fieldScreenScheme.getFieldScreen((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION)).map(fieldScreen -> fieldScreen.getTabs().stream()).orElse(Stream.empty()).flatMap(tab -> tab.getFieldScreenLayoutItems().stream()).map(FieldScreenLayoutItem::getFieldId).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        private void addParameters(Issue issue, CustomField customField, CustomFieldType customFieldType, Object value, Stream.Builder<Parameter> builder) {
            if (value == null) {
                return;
            }
            String changelogValue = customFieldType.getChangelogValue(customField, value);
            if (changelogValue != null) {
                String changelogString = customFieldType.getChangelogString(customField, value);
                if (changelogString == null) {
                    changelogString = changelogValue;
                    changelogValue = null;
                }
                DbStorageUtil.ObjectTypeIndexed objectTypeIndexed = new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.customFieldChangeItemOf((String)customField.getNameKey()));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)objectTypeIndexed, (String)"newstring"), changelogString));
                if (changelogValue != null) {
                    builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)objectTypeIndexed, (String)"newvalue"), changelogValue));
                }
                if (customField.isRenderable()) {
                    builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)objectTypeIndexed, (String)"renderer"), this.fieldRenderer.getRenderer(issue, customField.getId())));
                    builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)objectTypeIndexed, (String)"value"), customField.getValueFromIssue(issue)));
                }
            }
        }

        public Optional<Void> convertTo(Stream<Parameter> parameters, ParameterConverter.Context context) {
            return Optional.empty();
        }

        private void handleSummary(Issue issue, Stream.Builder<Parameter> builder) {
            if (StringUtils.isNotEmpty((CharSequence)issue.getSummary())) {
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.SUMMARY), (String)"newstring"), issue.getSummary()));
            }
        }

        private void handleTimeTracking(Issue issue, Stream.Builder<Parameter> builder) {
            if (issue.getOriginalEstimate() != null) {
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.TIME_ORIGINAL_ESTIMATE), (String)"newvalue"), "" + issue.getOriginalEstimate()));
            }
            if (issue.getEstimate() != null) {
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.TIME_REMAINING_ESTIMATE), (String)"newvalue"), "" + issue.getEstimate()));
            }
            if (issue.getTimeSpent() != null) {
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.TIME_SPENT), (String)"newvalue"), "" + issue.getTimeSpent()));
            }
        }

        private void handleDescription(Issue issue, Stream.Builder<Parameter> builder) {
            if (StringUtils.isNotEmpty((CharSequence)issue.getDescription())) {
                TemplateIssue templateIssue = this.templateIssueFactory.getTemplateIssue(issue);
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.DESCRIPTION), (String)"newstring"), issue.getDescription()));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.DESCRIPTION_HTML), (String)"newstring"), templateIssue.getHtmlDescription()));
            }
        }

        private void handleSecurityLevel(Issue issue, Stream.Builder<Parameter> builder) {
            if (issue.getSecurityLevelId() != null) {
                DbStorageUtil.ObjectTypeIndexed securityObjectType = new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.SECURITY);
                String value = Optional.ofNullable(this.issueSecurityLevelManager.getSecurityLevel(issue.getSecurityLevelId().longValue())).map(sl -> sl.getName() + (StringUtils.isEmpty((CharSequence)sl.getDescription()) ? "" : String.format(" (%s)", sl.getDescription()))).orElse("" + issue.getSecurityLevelId());
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)securityObjectType, (String)"newvalue"), "" + issue.getSecurityLevelId()));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)securityObjectType, (String)"newstring"), value));
            }
        }

        private void handleIssueUser(Issue issue, Stream.Builder<Parameter> builder, String fieldName, ApplicationUser user) {
            if (user != null) {
                DbStorageUtil.ObjectTypeIndexed objectType = new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.systemChangeItemOf((String)fieldName));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)objectType, (String)"newvalue"), user.getKey()));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)objectType, (String)"newstring"), user.getDisplayName()));
            }
        }

        private void handleIssueConstant(Issue issue, Stream.Builder<Parameter> builder, String fieldName, IssueConstant issueConstant) {
            if (issueConstant != null) {
                DbStorageUtil.ObjectTypeIndexed objectType = new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.systemChangeItemOf((String)fieldName));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)objectType, (String)"newvalue"), issueConstant.getId()));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)objectType, (String)"newstring"), issueConstant.getName()));
            }
        }

        private void handleLabels(Issue issue, Stream.Builder<Parameter> builder) {
            if (issue.getLabels() != null && !issue.getLabels().isEmpty()) {
                String labelsJoined = issue.getLabels().stream().map(Label::getLabel).collect(Collectors.joining(" "));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.LABELS, 0), (String)"newstring"), labelsJoined));
            }
        }

        private void handleEnvironment(Issue issue, Stream.Builder<Parameter> builder) {
            if (StringUtils.isNotEmpty((CharSequence)issue.getEnvironment())) {
                TemplateIssue templateIssue = this.templateIssueFactory.getTemplateIssue(issue);
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.ENVIRONMENT), (String)"newstring"), issue.getEnvironment()));
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.ENVIRONMENT_HTML), (String)"newstring"), templateIssue.getHtmlEnvironment()));
            }
        }

        private void handleTimestamp(Issue issue, Stream.Builder<Parameter> builder, String fieldName, Timestamp timestamp) {
            if (timestamp != null) {
                DbStorageUtil.ObjectType timestampObjectType = ObjectTypes.ChangeItems.systemChangeItemOf((String)fieldName);
                builder.add((Parameter)new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(timestampObjectType), (String)"newvalue"), "" + timestamp.getTime()));
            }
        }

        private void handleAttachments(Issue issue, Stream.Builder<Parameter> builder) {
            if (issue.getAttachments() != null) {
                AtomicInteger index = new AtomicInteger();
                issue.getAttachments().stream().flatMap(attachment -> Stream.of(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.ATTACHMENT, index.get()), (String)"newstring"), attachment.getFilename()), new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.ChangeItems.ATTACHMENT, index.getAndIncrement()), (String)"newvalue"), "" + attachment.getId()))).forEach(builder::add);
            }
        }

        private void handleProjectConstantCollection(Issue issue, Stream.Builder<Parameter> builder, String fieldName, Collection<? extends ProjectConstant> projectConstants) {
            if (projectConstants != null) {
                DbStorageUtil.ObjectType componentObjectType = ObjectTypes.ChangeItems.systemChangeItemOf((String)fieldName);
                AtomicInteger index = new AtomicInteger();
                projectConstants.stream().flatMap(projectConstant -> Stream.of(new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(componentObjectType, index.get()), (String)"newstring"), projectConstant.getName()), new ParameterDTO(null, DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(componentObjectType, index.getAndIncrement()), (String)"newvalue"), "" + projectConstant.getId()))).forEach(builder::add);
            }
        }
    }

    public static class IssueView {
        private final long id;
        private final String key;
        private final String summary;
        private final IssueType type;
        private final StatusView statusView;
        private final StatusView statusViewDb;
        private final boolean exists;

        public IssueView(long id, String key, String summary, IssueType type, StatusView statusView, StatusView statusViewDb, boolean exists) {
            this.id = id;
            this.key = key;
            this.summary = summary;
            this.type = type;
            this.statusView = statusView;
            this.statusViewDb = statusViewDb;
            this.exists = exists;
        }

        public long getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getSummary() {
            return this.summary;
        }

        public IssueType getType() {
            return this.type;
        }

        public StatusView getStatusView() {
            return this.statusView;
        }

        public StatusView getStatusViewDb() {
            return this.statusViewDb;
        }

        public boolean getExists() {
            return this.exists;
        }

        public IssueView withId(long newId) {
            return new IssueView(newId, this.key, this.summary, this.type, this.statusView, this.statusViewDb, this.exists);
        }

        public IssueView withKey(String newKey) {
            return new IssueView(this.id, newKey, this.summary, this.type, this.statusView, this.statusViewDb, this.exists);
        }

        public IssueView withSummary(String newSummary) {
            return new IssueView(this.id, this.key, newSummary, this.type, this.statusView, this.statusViewDb, this.exists);
        }

        public IssueView withType(IssueType newType) {
            return new IssueView(this.id, this.key, this.summary, newType, this.statusView, this.statusViewDb, this.exists);
        }

        public IssueView withExists(boolean newExists) {
            return new IssueView(this.id, this.key, this.summary, this.type, this.statusView, this.statusViewDb, newExists);
        }

        public IssueView withStatusView(StatusView newStatusView) {
            return new IssueView(this.id, this.key, this.summary, this.type, newStatusView, this.statusViewDb, this.exists);
        }

        public IssueView withStatusViewDb(StatusView newStatusViewDb) {
            return new IssueView(this.id, this.key, this.summary, this.type, this.statusView, newStatusViewDb, this.exists);
        }
    }

    public static class StatusView {
        private final String id;
        private final String name;
        private final String categoryKey;

        public StatusView(String id, String name, String categoryKey) {
            this.id = id;
            this.name = name;
            this.categoryKey = categoryKey;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getCategoryKey() {
            return this.categoryKey;
        }

        public StatusView withId(String newId) {
            return new StatusView(newId, this.name, this.categoryKey);
        }

        public StatusView withName(String newName) {
            return new StatusView(this.id, newName, this.categoryKey);
        }

        public StatusView withCategoryKey(String newCategoryKey) {
            return new StatusView(this.id, this.name, newCategoryKey);
        }
    }

    @ExportAsService(value={IssueParameterConverter.class})
    @Component
    @Order(value=100)
    public static class IssueParameterConverter
    implements ParameterConverter<IssueView> {
        public static final String NAME_KEY = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.ISSUE), (String)"key");
        private static final String NAME_ID = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.ISSUE), (String)"id");
        private static final String NAME_SUMMARY = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.ISSUE), (String)"summary");
        private static final String NAME_TYPE = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.ISSUE), (String)"type");
        private static final String NAME_STATUS_NAME = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.ISSUE), (String)"status_name");
        private static final String NAME_STATUS_ID = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.ISSUE), (String)"status_id");
        private static final String NAME_STATUS_CATEGORY_KEY = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.ISSUE), (String)"status_category");
        private static final String NAME_CREATED_DATE = DbStorageUtil.encodeField((DbStorageUtil.ObjectTypeIndexed)new DbStorageUtil.ObjectTypeIndexed(ObjectTypes.Objects.ISSUE), (String)"created_date");
        private final IssueManager issueManager;
        private final IssueTypeManager issueTypeManager;
        private final StatusManager statusManager;
        private final I18nHelper.BeanFactory i18nHelperBeanFactory;

        @Autowired
        public IssueParameterConverter(@ComponentImport IssueManager issueManager, @ComponentImport IssueTypeManager issueTypeManager, @ComponentImport StatusManager statusManager, @ComponentImport I18nHelper.BeanFactory i18nHelperBeanFactory) {
            this.issueTypeManager = issueTypeManager;
            this.issueManager = issueManager;
            this.statusManager = statusManager;
            this.i18nHelperBeanFactory = i18nHelperBeanFactory;
        }

        public Stream<Parameter> convertFrom(IssueEvent event) {
            if (event.getIssue() != null) {
                return Stream.of(new ParameterDTO(null, NAME_ID, String.valueOf(event.getIssue().getId())), new ParameterDTO(null, NAME_KEY, event.getIssue().getKey()), new ParameterDTO(null, NAME_SUMMARY, event.getIssue().getSummary()), new ParameterDTO(null, NAME_TYPE, Optional.ofNullable(event.getIssue().getIssueType()).map(IssueConstant::getId).orElse("")), new ParameterDTO(null, NAME_STATUS_NAME, Optional.ofNullable(event.getIssue().getStatus()).map(IssueConstant::getName).orElse("")), new ParameterDTO(null, NAME_STATUS_ID, Optional.ofNullable(event.getIssue().getStatus()).map(IssueConstant::getId).orElse("")), new ParameterDTO(null, NAME_STATUS_CATEGORY_KEY, Optional.ofNullable(event.getIssue().getStatus()).map(Status::getStatusCategory).map(StatusCategory::getKey).orElse("")), new ParameterDTO(null, NAME_CREATED_DATE, (String)Optional.ofNullable(event.getIssue().getCreated()).map(Timestamp::getTime).map(String::valueOf).orElse(null)));
            }
            return Stream.of(new Parameter[0]);
        }

        public Optional<IssueView> convertTo(Stream<Parameter> parameters, ParameterConverter.Context context) {
            IssueView issue = parameters.reduce(new IssueView(-1L, "", "", null, new StatusView(null, null, null), null, false), this::addParameter, (a, b) -> a);
            if (issue.getId() == -1L) {
                return Optional.empty();
            }
            issue = issue.withStatusViewDb(Optional.ofNullable(issue.getStatusView().getId()).map(arg_0 -> ((StatusManager)this.statusManager).getStatus(arg_0)).map(s -> new StatusView(s.getId(), s.getNameTranslation(this.i18nHelperBeanFactory.getInstance(context.getUser())), Optional.ofNullable(s.getStatusCategory()).map(StatusCategory::getKey).orElse(null))).orElse(null));
            return Optional.of(this.checkExists(issue));
        }

        private IssueView addParameter(IssueView source, Parameter parameter) {
            if (NAME_ID.equals(parameter.getName())) {
                return IssueParameterConverter.parseLong(parameter.getValue()).map(source::withId).orElse(source);
            }
            if (NAME_KEY.equals(parameter.getName())) {
                return source.withKey(parameter.getValue());
            }
            if (NAME_SUMMARY.equals(parameter.getName())) {
                return source.withSummary(parameter.getValue());
            }
            if (NAME_TYPE.equals(parameter.getName())) {
                return Optional.ofNullable(parameter.getValue()).filter(StringUtils::isNotEmpty).map(arg_0 -> ((IssueTypeManager)this.issueTypeManager).getIssueType(arg_0)).map(source::withType).orElse(source);
            }
            if (NAME_STATUS_NAME.equals(parameter.getName())) {
                return source.withStatusView(source.getStatusView().withName(parameter.getValue()));
            }
            if (NAME_STATUS_ID.equals(parameter.getName())) {
                return source.withStatusView(source.getStatusView().withId(parameter.getValue()));
            }
            if (NAME_STATUS_CATEGORY_KEY.equals(parameter.getName())) {
                return source.withStatusView(source.getStatusView().withCategoryKey(parameter.getValue()));
            }
            return source;
        }

        private IssueView checkExists(IssueView source) {
            return this.issueManager.getIssueObject(Long.valueOf(source.getId())) == null ? source.withExists(false) : source.withExists(true);
        }

        static Optional<Long> parseLong(String s) {
            try {
                return Optional.of(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
    }
}

