/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.anonymize;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.plugins.inform.api.events.EventSearchParams;
import com.atlassian.jira.plugins.inform.api.events.managers.EventManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class RemoveRecipientsAnonymizationHandler
implements UserAnonymizationHandler {
    private final EventManager eventManager;

    public RemoveRecipientsAnonymizationHandler(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserAnonymizationParameter parameter) {
        EventSearchParams.RecipientData recipientQuery = EventSearchParams.RecipientData.newBuilder().recipients((Collection)ImmutableList.of((Object)parameter.getUserKey())).build();
        long matches = this.eventManager.count(EventSearchParams.newBuilder().recipientData(recipientQuery).build());
        if (matches > 0L) {
            return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.REMOVE).numberOfOccurrences(Long.valueOf(matches)).descriptionKey("issue.update.event.recipient.user.reference").build());
        }
        return ImmutableList.of();
    }

    @Nonnull
    public ServiceResult update(@Nonnull UserAnonymizationParameter parameter) {
        try {
            this.eventManager.removeRecipients(parameter.getUserKey());
        }
        finally {
            ContextUtil.updateProgress((Context)parameter.getContext(), (int)this.getNumberOfTasks(parameter));
        }
        return new ServiceResultImpl();
    }

    public int getNumberOfTasks(@Nonnull UserAnonymizationParameter userPropertyChangeParameter) {
        return 1;
    }
}

