/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.upgradetasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CachingFeatureManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugins.inform.batching.configuration.FeatureUsageManager;
import com.atlassian.jira.plugins.inform.flags.JiraInformFeatureFlags;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetBatchingOnAsDefaultUpgradeTask
implements UpgradeTask {
    private final FeatureUsageManager featureUsageManager;
    private final OfBizDelegator ofBizDelegator;

    @Autowired
    public SetBatchingOnAsDefaultUpgradeTask(FeatureUsageManager featureUsageManager, @ComponentImport OfBizDelegator ofBizDelegator) {
        this.featureUsageManager = featureUsageManager;
        this.ofBizDelegator = ofBizDelegator;
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        try {
            if (!this.featureUsageManager.wasFeatureEnabled() && this.isFeatureNotEnabledInDatabase()) {
                this.enableMailBatching();
                this.clearFeatureCache();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isFeatureNotEnabledInDatabase() {
        String featureKey = JiraInformFeatureFlags.MAIL_BATCHING.enabledFeatureKey();
        List byField = this.ofBizDelegator.findByField("Feature", "featureName", (Object)featureKey);
        return byField == null || byField.size() == 0;
    }

    private void enableMailBatching() throws GenericEntityException {
        String featureKeyToSet = JiraInformFeatureFlags.MAIL_BATCHING.enabledFeatureKey();
        this.ofBizDelegator.createValue("Feature", (Map)ImmutableMap.of((Object)"featureName", (Object)featureKeyToSet, (Object)"featureType", (Object)"site")).store();
    }

    void clearFeatureCache() {
        ComponentAccessor.getComponentSafely(CachingFeatureManager.class).ifPresent(CachingFeatureManager::reset);
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Sets mail notification batching as default on for the instance if it hasn't been disabled before.";
    }
}

