/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.recipients.filters;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.notification.NotificationFilter;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugins.inform.batching.recipients.filters.BatchingNotificationFilter;
import com.atlassian.jira.plugins.inform.flags.JiraInformFeatureFlags;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConditionalNotificationFilter
implements NotificationFilter {
    private final NotificationFilter delegate;
    private final FeatureManager featureManager;

    @Autowired
    public ConditionalNotificationFilter(BatchingNotificationFilter delegate, @ComponentImport FeatureManager featureManager) {
        this.delegate = delegate;
        this.featureManager = featureManager;
    }

    private boolean isEnabled() {
        return this.featureManager.isEnabled(JiraInformFeatureFlags.MAIL_BATCHING) && this.featureManager.isEnabled(JiraInformFeatureFlags.OVERRIDE_CORE_NOTIFICATIONS);
    }

    public Iterable<NotificationRecipient> addRecipient(NotificationFilterContext context, Iterable<NotificationRecipient> recipients) {
        if (this.isEnabled()) {
            return this.delegate.addRecipient(context, recipients);
        }
        return ImmutableList.of();
    }

    public boolean removeRecipient(NotificationRecipient recipient, NotificationFilterContext context) {
        return this.isEnabled() && this.delegate.removeRecipient(recipient, context);
    }
}

