/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.recipients.filters;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.plugins.inform.api.events.IssueEventParameter;
import com.atlassian.jira.plugins.inform.batching.recipients.RecipientFilter;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentPermissionRecipientFilter
implements RecipientFilter {
    private final ProjectRoleManager projectRoleManager;
    private final GroupManager groupManager;

    @Autowired
    public CommentPermissionRecipientFilter(@ComponentImport ProjectRoleManager projectRoleManager, @ComponentImport GroupManager groupManager) {
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
    }

    @Override
    public Boolean apply(IssueEvent event, ApplicationUser user) {
        boolean result;
        Comment comment = event.getComment();
        Worklog worklog = event.getWorklog();
        boolean checkOriginalCommentPermissions = (Boolean)IssueEventParameter.CHECK_PREVIOUS_COMMENT_PERMISSIONS_PARAMETER.get(event);
        boolean checkOriginalWorklogPermissions = (Boolean)IssueEventParameter.CHECK_PREVIOUS_WORKLOG_PERMISSIONS_PARAMETER.get(event);
        boolean invertOriginalEntityPermissions = (Boolean)IssueEventParameter.INVERT_PREVIOUS_ENTITY_PERMISSIONS_PARAMETER.get(event);
        boolean invertNewEntityPermissions = (Boolean)IssueEventParameter.INVERT_NEW_ENTITY_PERMISSIONS_PARAMETER.get(event);
        boolean bl = result = this.checkRole(event, comment, user) && this.checkGroup(comment, user) && this.checkWorklogRole(event, worklog, user) && this.checkWorklogGroup(worklog, user);
        if (checkOriginalCommentPermissions) {
            boolean originalCommentResult;
            Comment commentOriginal = (Comment)event.getParams().get("originalcomment");
            boolean bl2 = originalCommentResult = this.checkRole(event, commentOriginal, user) && this.checkGroup(commentOriginal, user);
            if (invertOriginalEntityPermissions) {
                originalCommentResult = !originalCommentResult;
            }
            return result && originalCommentResult;
        }
        if (checkOriginalWorklogPermissions) {
            boolean originalWorklogResult;
            Worklog worklogOriginal = (Worklog)event.getParams().get("originalworklog");
            boolean bl3 = originalWorklogResult = this.checkWorklogRole(event, worklogOriginal, user) && this.checkWorklogGroup(worklogOriginal, user);
            if (invertOriginalEntityPermissions) {
                originalWorklogResult = !originalWorklogResult;
            }
            return result && originalWorklogResult;
        }
        return invertNewEntityPermissions ? !result : result;
    }

    private boolean checkRole(IssueEvent event, Comment comment, ApplicationUser user) {
        if (comment != null && comment.getRoleLevel() != null) {
            return this.projectRoleManager.isUserInProjectRole(user, comment.getRoleLevel(), event.getProject());
        }
        return true;
    }

    private boolean checkGroup(Comment comment, ApplicationUser user) {
        if (comment != null && comment.getGroupLevel() != null) {
            return this.groupManager.isUserInGroup(user, comment.getGroupLevel());
        }
        return true;
    }

    private boolean checkWorklogRole(IssueEvent event, Worklog worklog, ApplicationUser user) {
        if (worklog != null && worklog.getRoleLevel() != null) {
            return this.projectRoleManager.isUserInProjectRole(user, worklog.getRoleLevel(), event.getProject());
        }
        return true;
    }

    private boolean checkWorklogGroup(Worklog worklog, ApplicationUser user) {
        if (worklog != null && worklog.getGroupLevel() != null) {
            return this.groupManager.isUserInGroup(user, worklog.getGroupLevel());
        }
        return true;
    }
}

