/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.recipients;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.type.NotificationType;
import com.atlassian.jira.plugins.inform.batching.recipients.BatchingNotificationFiterManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecipientRetriever {
    private static final Logger log = LoggerFactory.getLogger(RecipientRetriever.class);
    private final NotificationSchemeManager notificationSchemeManager;
    private final BatchingNotificationFiterManager batchingNotificationFiterManager;

    @Autowired
    public RecipientRetriever(@ComponentImport NotificationSchemeManager notificationSchemeManager, BatchingNotificationFiterManager batchingNotificationFiterManager) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.batchingNotificationFiterManager = batchingNotificationFiterManager;
    }

    public Stream<ApplicationUser> get(IssueEvent issueEvent) {
        NotificationFilterContext context = this.batchingNotificationFiterManager.makeContextFrom((NotificationReason)JiraNotificationReason.ISSUE_EVENT, issueEvent);
        try {
            List schemeEntities = this.notificationSchemeManager.getNotificationSchemeEntities(issueEvent.getProject(), issueEvent.getEventTypeId().longValue());
            return this.getRecipients(issueEvent, context, schemeEntities);
        }
        catch (GenericEntityException e) {
            log.error("There was an error accessing the notification scheme for the project: " + issueEvent.getProject() + '.', (Throwable)e);
            return Stream.of(new ApplicationUser[0]);
        }
    }

    public Stream<ApplicationUser> getRecipients(IssueEvent issueEvent, NotificationFilterContext context, List<SchemeEntity> schemeEntities) {
        return schemeEntities.stream().flatMap(schemeEntity -> {
            try {
                return StreamSupport.stream(this.batchingNotificationFiterManager.recomputeRecipients(this.notificationSchemeManager.getRecipients(issueEvent, schemeEntity), this.batchingNotificationFiterManager.makeContextFrom(context, NotificationType.from((String)schemeEntity.getType()))).spliterator(), false);
            }
            catch (GenericEntityException e) {
                log.error("There was an error accessing the notification scheme recipients for the project: " + issueEvent.getProject() + '.', (Throwable)e);
                return Stream.empty();
            }
        }).map(NotificationRecipient::getUser);
    }
}

