/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.cron;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncePerClusterJobRunner
implements JobRunner {
    public static String LOCK_ID_PARAMETER = "clusterLockId";
    private static final Logger logger = LoggerFactory.getLogger(OncePerClusterJobRunner.class);
    private final JobRunner delegate;
    private final ClusterLockService clusterLockService;

    public OncePerClusterJobRunner(JobRunner delegate, ClusterLockService clusterLockService) {
        this.delegate = delegate;
        this.clusterLockService = clusterLockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String lockId = Objects.requireNonNull((String)request.getJobConfig().getParameters().get(LOCK_ID_PARAMETER), String.format("%s job config parameter is required", LOCK_ID_PARAMETER));
        ClusterLock lock = this.clusterLockService.getLockForName(lockId);
        if (lock.tryLock()) {
            try {
                JobRunnerResponse jobRunnerResponse = this.delegate.runJob(request);
                return jobRunnerResponse;
            }
            finally {
                lock.unlock();
            }
        }
        logger.info("Skipping the execution of the notification batcher (%s). Another node may be running it.", (Object)lockId);
        return JobRunnerResponse.success();
    }
}

