/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.cron;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.inform.batching.cron.BatchJobQualifier;
import com.atlassian.jira.plugins.inform.batching.cron.BatchNotificationJob;
import com.atlassian.jira.plugins.inform.batching.cron.ConditionalJobRunner;
import com.atlassian.jira.plugins.inform.batching.cron.OncePerClusterJobRunner;
import com.atlassian.jira.plugins.inform.flags.JiraInformFeatureFlags;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BatchNotificationJobConfig {
    @Autowired
    BatchNotificationJob batchNotificationJob;
    @Autowired
    FeatureManager featureManager;
    @ComponentImport
    @Autowired
    ClusterLockService clusterLockService;

    @Bean
    @BatchJobQualifier
    public JobRunner getBatchingJobRunner() {
        ConditionalJobRunner userNotificationEnabledJobRunner = new ConditionalJobRunner(this.batchNotificationJob, JiraInformFeatureFlags.USER_NOTIFICATION, this.featureManager);
        ConditionalJobRunner mailBatchingEnabledJobRunner = new ConditionalJobRunner(userNotificationEnabledJobRunner, JiraInformFeatureFlags.MAIL_BATCHING, this.featureManager);
        return new OncePerClusterJobRunner(mailBatchingEnabledJobRunner, this.clusterLockService);
    }
}

