/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching;

import com.atlassian.botocss.Botocss;
import com.atlassian.botocss.BotocssStyles;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.mail.util.MailAttachmentsManagerFactory;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugin.OrderableModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugins.inform.api.batching.Batch;
import com.atlassian.jira.plugins.inform.api.batching.Batcher;
import com.atlassian.jira.plugins.inform.api.batching.BatcherService;
import com.atlassian.jira.plugins.inform.api.batching.EmailParametersProvider;
import com.atlassian.jira.plugins.inform.api.batching.MailType;
import com.atlassian.jira.plugins.inform.api.batching.Template;
import com.atlassian.jira.plugins.inform.api.batching.TemplateProvider;
import com.atlassian.jira.plugins.inform.api.batching.rendering.ContextProvider;
import com.atlassian.jira.plugins.inform.batching.PostprocessingMailQueueItem;
import com.atlassian.jira.plugins.inform.batching.module.BatcherModuleDescriptor;
import com.atlassian.jira.plugins.inform.batching.module.ContextProviderModuleDescriptor;
import com.atlassian.jira.plugins.inform.batching.module.EmailParametersProviderModuleDescriptor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class BatcherServiceImpl
implements BatcherService {
    private static final int BOTOCSS_CACHE_EXPIRE_MINUTES = 5;
    static final String SUBJECT_RENDERING_ERROR = "jira.inform.subject.rendering.error";
    static final String CONTENT_RENDERING_ERROR = "jira.inform.content.rendering.error";
    private final TemplateProvider templateProvider;
    private final MailQueue mailQueue;
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;
    private final ContextProvider defaultContextProvider;
    private final I18nHelper.BeanFactory i18nHelperBeanFactory;
    private final LoadingCache<String, BotocssStyles> botocssStyles;
    private final Supplier<List<Batcher>> batcherModuleSupplier;
    private final Supplier<List<EmailParametersProvider>> emailParametersProviderModuleSupplier;

    @Autowired
    public BatcherServiceImpl(TemplateProvider templateProvider, @ComponentImport MailQueue mailQueue, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginEventManager pluginEventManager, @ComponentImport I18nHelper.BeanFactory i18nHelperBeanFactory, @Qualifier(value="defaultContextProvider") ContextProvider defaultContextProvider) {
        this.templateProvider = templateProvider;
        this.mailQueue = mailQueue;
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
        this.defaultContextProvider = defaultContextProvider;
        this.i18nHelperBeanFactory = i18nHelperBeanFactory;
        this.batcherModuleSupplier = new CacheableModuleSupplier<Batcher, BatcherModuleDescriptor>(BatcherModuleDescriptor.class);
        this.emailParametersProviderModuleSupplier = new CacheableModuleSupplier<EmailParametersProvider, EmailParametersProviderModuleDescriptor>(EmailParametersProviderModuleDescriptor.class);
        this.botocssStyles = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new BotocssCreator());
    }

    public Collection<Batcher> getBatchers(String eventConsumerName) {
        List<Batcher> batchers = this.batcherModuleSupplier.get();
        if (eventConsumerName == null) {
            return batchers;
        }
        return batchers.stream().filter(b -> b.getSupportedEventConsumers().contains(eventConsumerName)).collect(Collectors.toList());
    }

    private Collection<ContextProvider> getContextProviders() {
        return Stream.concat(Stream.of(this.defaultContextProvider), this.pluginAccessor.getEnabledModuleDescriptorsByClass(ContextProviderModuleDescriptor.class).stream().map(ContextProviderModuleDescriptor::getModule)).collect(Collectors.toList());
    }

    public void sendEmail(com.atlassian.jira.mail.Email email, Runnable successHandler, Runnable errorHandler) {
        PostprocessingMailQueueItem mailItem = new PostprocessingMailQueueItem((MailQueueItem)new SingleMailQueueItem((Email)email), successHandler, errorHandler);
        this.mailQueue.addItem((MailQueueItem)mailItem);
    }

    public void sendEmail(MailQueueItem mailQueueItem, Runnable success, Runnable error) {
        this.mailQueue.addItem((MailQueueItem)new PostprocessingMailQueueItem(mailQueueItem, success, error));
    }

    public com.atlassian.jira.mail.Email createEmail(Batch batch) throws MessagingException {
        String content;
        String subject;
        MailAttachmentsManager mailAttachmentsManager = this.getAttachmentsManager();
        NotificationRecipient recipient = batch.getRecipient();
        MailType mailType = this.getMailType(recipient);
        Template template = this.templateProvider.getTemplate(batch.getBatcher(), batch.getBatchingType(), mailType);
        Map<String, Object> context = this.getContext(batch, mailAttachmentsManager);
        com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(batch.getRecipient().getEmail());
        Optional<EmailParametersProvider> emailPropertiesProvider = this.getEmailPropertiesProvider(batch);
        emailPropertiesProvider.ifPresent(epp -> {
            email.setFrom(epp.getFromAddress(batch));
            email.setFromName(epp.getFromName(batch));
        });
        try {
            subject = template.renderSubject(context);
        }
        catch (VelocityException ignore) {
            subject = this.i18nHelperBeanFactory.getInstance(recipient.getUser()).getText(SUBJECT_RENDERING_ERROR);
        }
        email.setSubject(StringUtils.trimToEmpty((String)subject));
        try {
            content = template.renderContent(context);
        }
        catch (VelocityException e) {
            String content2 = this.i18nHelperBeanFactory.getInstance(recipient.getUser()).getText(CONTENT_RENDERING_ERROR);
            email.setBody(content2);
            email.setMimeType(MailType.TEXT.getMimeType());
            return email;
        }
        email.setMimeType(mailType.getMimeType());
        if (mailType == MailType.HTML) {
            List<BodyPart> bodyParts;
            content = mailAttachmentsManager.inlineImages(content);
            Optional css = template.getCssContent();
            if (css.isPresent()) {
                content = Botocss.inject((String)content, (BotocssStyles)((BotocssStyles)this.botocssStyles.getUnchecked(css.get())));
            }
            if (!(bodyParts = StreamSupport.stream(mailAttachmentsManager.buildAttachmentsBodyParts().spliterator(), false).collect(Collectors.toList())).isEmpty()) {
                String contentType = String.format("%s; charset=%s", email.getMimeType(), email.getEncoding());
                Multipart multiPart = this.buildMailWithAttachments(bodyParts, content, contentType);
                email.setMultipart(multiPart);
            } else {
                email.setBody(content);
            }
        } else {
            email.setBody(content);
        }
        return email;
    }

    private Optional<EmailParametersProvider> getEmailPropertiesProvider(Batch batch) {
        return this.emailParametersProviderModuleSupplier.get().stream().filter(epp -> epp.batcherSupported(batch.getBatcher().getName())).findFirst();
    }

    private MailType getMailType(NotificationRecipient recipient) {
        if ("text".equals(recipient.getFormat())) {
            return MailType.TEXT;
        }
        return MailType.HTML;
    }

    public Map<String, Object> getContext(Batch batch) {
        return this.getContext(batch, this.getAttachmentsManager());
    }

    private Map<String, Object> getContext(Batch batch, MailAttachmentsManager mailAttachmentsManager) {
        String batcherName = batch.getBatcher().getName();
        ContextProvider.ContextParameters contextParameters = new ContextProvider.ContextParameters(mailAttachmentsManager);
        Collection<ContextProvider> contextProviders = this.getContextProviders();
        Map<String, Object> context = this.getContext(cp -> cp.createContext(batch, contextParameters), batcherName, contextProviders);
        Map<String, Object> additionalContext = this.getContext(cp -> cp.createAdditionalContext(context), batcherName, contextProviders);
        context.putAll(additionalContext);
        return context;
    }

    private Map<String, Object> getContext(Function<ContextProvider, Map<String, Object>> mapper, String batcherName, Collection<ContextProvider> contextProviders) {
        return contextProviders.stream().filter(provider -> provider.batcherSupported(batcherName)).map(mapper).reduce(Maps.newHashMap(), (a, b) -> {
            a.putAll(b);
            return a;
        });
    }

    private Multipart buildMailWithAttachments(Collection<BodyPart> bodyParts, String text, String textContentMimeType) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)text, textContentMimeType);
        multipart.addBodyPart((BodyPart)textPart);
        for (BodyPart bodyPart : bodyParts) {
            multipart.addBodyPart(bodyPart);
        }
        return multipart;
    }

    public boolean someBatcherSupportsEvent(IssueEvent issueEvent) {
        return this.getBatchers(null).stream().map(Batcher::getSupportedEventTypes).flatMap(Collection::stream).anyMatch(eventType -> eventType.equals(issueEvent.getEventTypeId()));
    }

    private MailAttachmentsManager getAttachmentsManager() {
        return ((MailAttachmentsManagerFactory)ComponentAccessor.getComponent(MailAttachmentsManagerFactory.class)).createAttachmentsManager();
    }

    private class CacheableModuleSupplier<M, T extends ModuleDescriptor<M> & OrderableModuleDescriptor>
    implements Supplier<List<M>> {
        private final PluginModuleTracker<M, T> moduleTracker;
        private final ResettableLazyReference<List<M>> resettableLazyReference;

        public CacheableModuleSupplier(Class<T> mdClass) {
            this.moduleTracker = new DefaultPluginModuleTracker(BatcherServiceImpl.this.pluginAccessor, BatcherServiceImpl.this.pluginEventManager, mdClass, new PluginModuleTracker.Customizer(){

                public ModuleDescriptor adding(ModuleDescriptor descriptor) {
                    if (CacheableModuleSupplier.this.resettableLazyReference != null) {
                        CacheableModuleSupplier.this.resettableLazyReference.reset();
                    }
                    return descriptor;
                }

                public void removed(ModuleDescriptor descriptor) {
                    if (CacheableModuleSupplier.this.resettableLazyReference != null) {
                        CacheableModuleSupplier.this.resettableLazyReference.reset();
                    }
                }
            });
            this.resettableLazyReference = new ResettableLazyReference<List<M>>(){

                protected List<M> create() throws Exception {
                    return StreamSupport.stream(CacheableModuleSupplier.this.moduleTracker.getModuleDescriptors().spliterator(), false).sorted(ModuleDescriptorComparator.COMPARATOR).map(ModuleDescriptor::getModule).collect(Collectors.toList());
                }
            };
        }

        @Override
        public List<M> get() {
            return (List)this.resettableLazyReference.get();
        }
    }

    private class BotocssCreator
    extends CacheLoader<String, BotocssStyles> {
        private BotocssCreator() {
        }

        public BotocssStyles load(String css) throws Exception {
            return BotocssStyles.parse((String[])new String[]{css});
        }
    }
}

