/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.issuetabpanels.changes;

import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.linkrenderer.SubversionLinkRenderer;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.util.JiraKeyUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class SubversionRevisionAction
extends AbstractIssueAction {
    private final SVNLogEntry revision;
    private final long repoId;
    protected final IssueTabPanelModuleDescriptor descriptor;
    protected MultipleSubversionRepositoryManager multipleSubversionRepositoryManager;

    public SubversionRevisionAction(SVNLogEntry logEntry, MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, IssueTabPanelModuleDescriptor descriptor, long repoId) {
        super(descriptor);
        this.multipleSubversionRepositoryManager = multipleSubversionRepositoryManager;
        this.descriptor = descriptor;
        this.revision = new SVNLogEntry(logEntry.getChangedPaths(), logEntry.getRevision(), logEntry.getAuthor(), logEntry.getDate(), this.rewriteLogMessage(logEntry.getMessage()));
        this.repoId = repoId;
    }

    protected void populateVelocityParams(Map params) {
        params.put("stringUtils", new StringUtils());
        params.put("svn", this);
    }

    public SubversionLinkRenderer getLinkRenderer() {
        return this.multipleSubversionRepositoryManager.getRepository(this.repoId).getLinkRenderer();
    }

    public String getRepositoryDisplayName() {
        return this.multipleSubversionRepositoryManager.getRepository(this.repoId).getDisplayName();
    }

    public Date getTimePerformed() {
        if (this.revision.getDate() == null) {
            throw new UnsupportedOperationException("no revision date for this log entry");
        }
        return this.revision.getDate();
    }

    public long getRepoId() {
        return this.repoId;
    }

    public String getUsername() {
        return this.revision.getAuthor();
    }

    public SVNLogEntry getRevision() {
        return this.revision;
    }

    public boolean isAdded(SVNLogEntryPath logEntryPath) {
        return 'A' == logEntryPath.getType();
    }

    public boolean isModified(SVNLogEntryPath logEntryPath) {
        return 'M' == logEntryPath.getType();
    }

    public boolean isReplaced(SVNLogEntryPath logEntryPath) {
        return 'R' == logEntryPath.getType();
    }

    public boolean isDeleted(SVNLogEntryPath logEntryPath) {
        return 'D' == logEntryPath.getType();
    }

    protected String rewriteLogMessage(String logMessageToBeRewritten) {
        String logMessage = logMessageToBeRewritten;
        String logMessageUpperCase = StringUtils.upperCase((String)logMessage);
        HashSet<String> issueKeys = new HashSet<String>(this.getIssueKeysFromCommitMessage(logMessageUpperCase));
        for (String issueKey : issueKeys) {
            logMessage = logMessage.replaceAll("(?ium)" + issueKey, issueKey);
        }
        return logMessage;
    }

    List<String> getIssueKeysFromCommitMessage(String logMessageUpperCase) {
        return JiraKeyUtils.getIssueKeysFromString((String)logMessageUpperCase);
    }
}

