/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.action;

import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.SvnProperties;
import com.atlassian.jira.plugin.ext.subversion.action.SubversionActionSupport;
import com.opensymphony.util.TextUtils;

public class AddSubversionRepositoryAction
extends SubversionActionSupport
implements SvnProperties {
    private String root;
    private String displayName;
    private String username;
    private String password;
    private String privateKeyFile;
    private Boolean revisionIndexing = Boolean.TRUE;
    private Integer revisionCacheSize = new Integer(10000);
    private String webLinkType;
    private String viewFormat;
    private String changesetFormat;
    private String fileAddedFormat;
    private String fileModifiedFormat;
    private String fileReplacedFormat;
    private String fileDeletedFormat;

    public AddSubversionRepositoryAction(MultipleSubversionRepositoryManager manager) {
        super(manager);
    }

    public void doValidation() {
        if (!TextUtils.stringSet((String)this.getDisplayName())) {
            this.addError("dipalyName", this.getText("subversion.errors.you.must.specify.a.name.for.the.repository"));
        }
        this.validateRepositoryParameters();
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root != null ? root.trim() : root;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = TextUtils.stringSet((String)username) ? username : null;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = TextUtils.stringSet((String)password) ? password : null;
    }

    @Override
    public Boolean getRevisionIndexing() {
        return this.revisionIndexing;
    }

    public void setRevisionIndexing(Boolean revisionIndexing) {
        this.revisionIndexing = revisionIndexing;
    }

    @Override
    public Integer getRevisionCacheSize() {
        return this.revisionCacheSize;
    }

    public void setRevisionCacheSize(Integer revisionCacheSize) {
        this.revisionCacheSize = revisionCacheSize;
    }

    @Override
    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = TextUtils.stringSet((String)privateKeyFile) ? privateKeyFile : null;
    }

    @Override
    public String getWebLinkType() {
        return this.webLinkType;
    }

    public void setWebLinkType(String webLinkType) {
        this.webLinkType = webLinkType;
    }

    @Override
    public String getChangesetFormat() {
        return this.changesetFormat;
    }

    public void setChangesetFormat(String changesetFormat) {
        this.changesetFormat = TextUtils.stringSet((String)changesetFormat) ? changesetFormat : null;
    }

    @Override
    public String getFileAddedFormat() {
        return this.fileAddedFormat;
    }

    public void setFileAddedFormat(String fileAddedFormat) {
        this.fileAddedFormat = TextUtils.stringSet((String)fileAddedFormat) ? fileAddedFormat : null;
    }

    @Override
    public String getViewFormat() {
        return this.viewFormat;
    }

    public void setViewFormat(String viewFormat) {
        this.viewFormat = TextUtils.stringSet((String)viewFormat) ? viewFormat : null;
    }

    @Override
    public String getFileModifiedFormat() {
        return this.fileModifiedFormat;
    }

    public void setFileModifiedFormat(String fileModifiedFormat) {
        this.fileModifiedFormat = TextUtils.stringSet((String)fileModifiedFormat) ? fileModifiedFormat : null;
    }

    @Override
    public String getFileReplacedFormat() {
        return this.fileReplacedFormat;
    }

    public void setFileReplacedFormat(String fileReplacedFormat) {
        this.fileReplacedFormat = TextUtils.stringSet((String)fileReplacedFormat) ? fileReplacedFormat : null;
    }

    @Override
    public String getFileDeletedFormat() {
        return this.fileDeletedFormat;
    }

    public void setFileDeletedFormat(String fileDeletedFormat) {
        this.fileDeletedFormat = TextUtils.stringSet((String)fileDeletedFormat) ? fileDeletedFormat : null;
    }

    public String doExecute() throws Exception {
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        SubversionManager subversionManager = this.getMultipleRepoManager().createRepository(this);
        if (!subversionManager.isActive()) {
            this.addErrorMessage(subversionManager.getInactiveMessage());
            this.addErrorMessage(this.getText("admin.errors.occured.when.creating"));
            this.getMultipleRepoManager().removeRepository(subversionManager.getId());
            return "error";
        }
        return this.getRedirect("ViewSubversionRepositories.jspa");
    }

    public void validateRepositoryParameters() {
        if (!TextUtils.stringSet((String)this.getDisplayName())) {
            this.addError("displayName", this.getText("subversion.errors.you.must.specify.a.name.for.the.repository"));
        }
        if (!TextUtils.stringSet((String)this.getRoot())) {
            this.addError("root", this.getText("subversion.errors.you.must.specify.the.root.of.the.repository"));
        }
    }
}

