/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.SubversionManagerImpl;
import com.atlassian.jira.plugin.ext.subversion.SvnProperties;
import com.atlassian.jira.plugin.ext.subversion.messages.DefaultIndexMessageService;
import com.atlassian.jira.plugin.ext.subversion.messages.IndexMessageService;
import com.atlassian.jira.plugin.ext.subversion.revisions.RevisionIndexer;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;

public class MultipleSubversionRepositoryManagerImpl
implements MultipleSubversionRepositoryManager,
LifecycleAware,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MultipleSubversionRepositoryManagerImpl.class);
    protected static final String REPOSITORY_INDEX_LOCK = MultipleSubversionRepositoryManagerImpl.class.getName() + ".repoIndexLock";
    public static final String APP_PROPERTY_PREFIX = "jira.plugins.subversion";
    public static final String REPO_PROPERTY = "jira.plugins.subversion.repo";
    public static final String LAST_REPO_ID = "last.repo.id";
    public static final long FIRST_REPO_ID = 1L;
    private final VersionManager versionManager;
    private final JiraPropertySetFactory jiraPropertySetFactory;
    private final ClusterLockService clusterLockService;
    private final CachedReference<Map<Long, SubversionManager>> cachedSvnManagers;
    private final ClusterMessagingService clusterMessagingService;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final IndexPathManager indexPathManager;
    private IndexMessageService indexMessageService;
    private RevisionIndexer revisionIndexer;

    public MultipleSubversionRepositoryManagerImpl(VersionManager versionManager, IssueManager issueManager, PermissionManager permissionManager, ChangeHistoryManager changeHistoryManager, JiraPropertySetFactory jiraPropertySetFactory, IndexPathManager indexPathManager, CacheManager cacheManager, ClusterLockService clusterLockService, ClusterMessagingService clusterMessagingService) {
        this.jiraPropertySetFactory = jiraPropertySetFactory;
        this.clusterLockService = clusterLockService;
        this.clusterMessagingService = clusterMessagingService;
        this.versionManager = versionManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.changeHistoryManager = changeHistoryManager;
        this.indexPathManager = indexPathManager;
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        this.cachedSvnManagers = cacheManager.getCachedReference(MultipleSubversionRepositoryManagerImpl.class, "cachedSvnManagers", (Supplier)new SvnManagerCacheSupplier(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void afterPropertiesSet() throws Exception {
        this.revisionIndexer = new RevisionIndexer(this, this.versionManager, this.issueManager, this.permissionManager, this.changeHistoryManager, this.indexPathManager);
        this.indexMessageService = new DefaultIndexMessageService(this.clusterMessagingService, this.revisionIndexer, this.cachedSvnManagers);
        this.indexMessageService.registerListeners();
    }

    public void onStart() {
        try {
            if (this.isIndexingRevisions()) {
                this.startRevisionIndexer();
            }
        }
        catch (InfrastructureException ie) {
            log.error("Error starting " + this.getClass(), (Throwable)ie);
        }
    }

    public void destroy() throws Exception {
        this.indexMessageService.unregisterListeners();
    }

    private Map<Long, SubversionManager> loadManagersFromJiraProperties() {
        PropertySet propertySet = this.jiraPropertySetFactory.buildNoncachingPropertySet(APP_PROPERTY_PREFIX);
        long lastRepoId = propertySet.getLong(LAST_REPO_ID);
        HashMap managers = Maps.newHashMap();
        for (long i = 1L; i <= lastRepoId; ++i) {
            SubversionManager manager = this.createManagerFromPropertySet(i, this.jiraPropertySetFactory.buildCachingPropertySet(REPO_PROPERTY, Long.valueOf(i), true));
            if (manager == null) continue;
            managers.put(i, manager);
        }
        return managers;
    }

    private SubversionManager createManagerFromPropertySet(long index, PropertySet properties) {
        try {
            if (properties.getKeys().isEmpty()) {
                return null;
            }
            return new SubversionManagerImpl(index, properties);
        }
        catch (IllegalArgumentException e) {
            log.error("Error creating SubversionManager " + index + ". Probably was missing a required field (e.g., repository name or root). Skipping it.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubversionManager createRepository(SvnProperties properties) {
        long repositoryId;
        ClusterLock lock = this.clusterLockService.getLockForName(REPOSITORY_INDEX_LOCK);
        PropertySet propertySet = this.jiraPropertySetFactory.buildNoncachingPropertySet(APP_PROPERTY_PREFIX);
        lock.lock();
        try {
            repositoryId = propertySet.getLong(LAST_REPO_ID) + 1L;
            propertySet.setLong(LAST_REPO_ID, repositoryId);
        }
        finally {
            lock.unlock();
        }
        SubversionManager subversionManager = this.createSubversionManager(properties, repositoryId);
        this.cachedSvnManagers.reset();
        if (this.isIndexingRevisions()) {
            this.indexMessageService.addIndexForRepository(repositoryId);
            this.revisionIndexer.addRepository(repositoryId);
        }
        return subversionManager;
    }

    @VisibleForTesting
    protected SubversionManager createSubversionManager(SvnProperties properties, long repoId) {
        PropertySet set = this.jiraPropertySetFactory.buildCachingPropertySet(REPO_PROPERTY, Long.valueOf(repoId));
        return new SubversionManagerImpl(repoId, SvnProperties.Util.fillPropertySet(properties, set));
    }

    @Override
    public SubversionManager updateRepository(long repoId, SvnProperties properties) {
        SubversionManager subversionManager = this.getRepository(repoId);
        subversionManager.update(properties);
        this.cachedSvnManagers.reset();
        return subversionManager;
    }

    @Override
    public void removeRepository(long repositoryId) {
        PropertySet original = this.jiraPropertySetFactory.buildCachingPropertySet(REPO_PROPERTY, Long.valueOf(repositoryId));
        try {
            this.indexMessageService.removeIndexForRepository(repositoryId);
            this.revisionIndexer.removeEntries(((SubversionManager)((Map)this.cachedSvnManagers.get()).get(repositoryId)).getId());
            original.remove();
            this.cachedSvnManagers.reset();
        }
        catch (Exception e) {
            throw new InfrastructureException("Could not remove repository index", (Throwable)e);
        }
    }

    @Override
    public boolean isIndexingRevisions() {
        return this.revisionIndexer != null;
    }

    @Override
    public RevisionIndexer getRevisionIndexer() {
        return this.revisionIndexer;
    }

    @Override
    public Collection<SubversionManager> getRepositoryList() {
        return ((Map)this.cachedSvnManagers.get()).values();
    }

    @Override
    public SubversionManager getRepository(long id) {
        return (SubversionManager)((Map)this.cachedSvnManagers.get()).get(id);
    }

    void startRevisionIndexer() {
        this.getRevisionIndexer().start();
    }

    private class SvnManagerCacheSupplier
    implements Supplier<Map<Long, SubversionManager>> {
        private SvnManagerCacheSupplier() {
        }

        public Map<Long, SubversionManager> get() {
            return MultipleSubversionRepositoryManagerImpl.this.loadManagersFromJiraProperties();
        }
    }
}

