/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion;

import java.util.Properties;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.io.SVNRepository;

public class ISVNAuthenticationManagerDelegator
implements ISVNAuthenticationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ISVNAuthenticationManagerDelegator.class);
    private final ISVNAuthenticationManager delegate;
    private static final String SYSTEM_PROPERTY_SVN_READ_TIMEOUT = "com.atlassian.jira.plugin.ext.subversion.svnreadtimeout";
    private static final String SYSTEM_PROPERTY_SVN_CONNECTION_TIMEOUT = "com.atlassian.jira.plugin.ext.subversion.svnconnectiontimeout";
    private static final int DEFAULT_READ_TIMEOUT = 120000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 120000;

    ISVNAuthenticationManagerDelegator(ISVNAuthenticationManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setAuthenticationProvider(ISVNAuthenticationProvider isvnAuthenticationProvider) {
        this.delegate.setAuthenticationProvider(isvnAuthenticationProvider);
    }

    @Override
    public ISVNProxyManager getProxyManager(SVNURL svnurl) throws SVNException {
        return this.delegate.getProxyManager(svnurl);
    }

    @Override
    public TrustManager getTrustManager(SVNURL svnurl) throws SVNException {
        return this.delegate.getTrustManager(svnurl);
    }

    @Override
    public SVNAuthentication getFirstAuthentication(String s, String s1, SVNURL svnurl) throws SVNException {
        return this.delegate.getFirstAuthentication(s, s1, svnurl);
    }

    @Override
    public SVNAuthentication getNextAuthentication(String s, String s1, SVNURL svnurl) throws SVNException {
        return this.delegate.getNextAuthentication(s, s1, svnurl);
    }

    @Override
    public void acknowledgeAuthentication(boolean b, String s, String s1, SVNErrorMessage svnErrorMessage, SVNAuthentication svnAuthentication) throws SVNException {
        this.delegate.acknowledgeAuthentication(b, s, s1, svnErrorMessage, svnAuthentication);
    }

    @Override
    public void acknowledgeTrustManager(TrustManager trustManager) {
        this.delegate.acknowledgeTrustManager(trustManager);
    }

    @Override
    public boolean isAuthenticationForced() {
        return this.delegate.isAuthenticationForced();
    }

    private int getTimeout(String systemProperty, int defaultValue) {
        int timeout = defaultValue;
        try {
            Properties systemProperties = System.getProperties();
            String timeoutString = StringUtils.trim((String)systemProperties.getProperty(systemProperty));
            if (StringUtils.isNotBlank((String)timeoutString) && (timeout = Integer.parseInt(timeoutString)) < 0) {
                timeout = defaultValue;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Unable to convert " + systemProperty + " to an int. The default of '" + defaultValue + "' will be used instead.");
        }
        return timeout;
    }

    @Override
    public int getReadTimeout(SVNRepository svnRepository) {
        return this.getTimeout(SYSTEM_PROPERTY_SVN_READ_TIMEOUT, 120000);
    }

    @Override
    public int getConnectTimeout(SVNRepository svnRepository) {
        return this.getTimeout(SYSTEM_PROPERTY_SVN_CONNECTION_TIMEOUT, 120000);
    }
}

