/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcDbRevertList
implements Comparator<RevertListRow> {
    private Map<String, RevertListRow> rows = new HashMap<String, RevertListRow>();
    private Map<String, RevertListRow> actualRows = new HashMap<String, RevertListRow>();

    @Override
    public int compare(RevertListRow r1, RevertListRow r2) {
        if (r1 == r2) {
            return 0;
        }
        if (r1 == null || r2 == null) {
            return r1 == null ? 1 : -1;
        }
        int paths = r1.localRelpath.compareTo(r2.localRelpath);
        if (paths != 0) {
            return paths;
        }
        return r1.actual > r2.actual ? 1 : (r1.actual == r2.actual ? 0 : -1);
    }

    public Iterator<RevertListRow> rows() {
        TreeSet<RevertListRow> combinedRows = new TreeSet<RevertListRow>(this);
        combinedRows.addAll(this.rows.values());
        combinedRows.addAll(this.actualRows.values());
        return combinedRows.iterator();
    }

    public void insertRow(String localRelpath, long actual, String conflictOld, String conflictNew, String conflictWorking, String propReject, long notify) {
        RevertListRow row = new RevertListRow();
        row.localRelpath = localRelpath;
        row.actual = actual;
        row.conflictNew = conflictNew;
        row.conflictOld = conflictOld;
        row.conflictWorking = conflictWorking;
        row.propReject = propReject;
        row.notify = notify;
        if (actual == 1L) {
            this.actualRows.put(localRelpath, row);
        } else {
            this.rows.put(localRelpath, row);
        }
    }

    public void insertRow(String localRelpath, int actual, long opDepth, long reposId, String kind) {
        RevertListRow row = new RevertListRow();
        row.localRelpath = localRelpath;
        row.actual = actual;
        row.opDepth = opDepth;
        row.reposId = reposId;
        row.kind = kind;
        if (actual == 1) {
            this.actualRows.put(localRelpath, row);
        } else {
            this.rows.put(localRelpath, row);
        }
    }

    public RevertListRow getRow(String localRelpath) {
        return this.rows.get(localRelpath);
    }

    public RevertListRow getActualRow(String localRelpath) {
        return this.actualRows.get(localRelpath);
    }

    public void deleteRow(String filePath) {
        this.actualRows.remove(filePath);
        this.rows.remove(filePath);
    }

    public static class RevertListRow {
        String localRelpath;
        long actual;
        String conflictOld;
        String conflictNew;
        String conflictWorking;
        String propReject;
        long notify;
        long opDepth;
        long reposId;
        String kind;

        public int hashCode() {
            return (int)((long)this.localRelpath.hashCode() + 57L * this.actual);
        }

        public boolean equals(Object o) {
            if (o instanceof RevertListRow) {
                RevertListRow that = (RevertListRow)o;
                return that.localRelpath.equals(this.localRelpath) && that.actual == this.actual;
            }
            return false;
        }
    }
}

