/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;

public class SVNWCDbDir {
    private File localAbsPath;
    private SVNWCDbRoot wcRoot;
    private SVNWCDbDir parent;
    private SVNWCAccess admAccess;

    public SVNWCDbDir(File localAbsPath) {
        this.localAbsPath = localAbsPath;
    }

    public File getLocalAbsPath() {
        return this.localAbsPath;
    }

    public SVNWCDbRoot getWCRoot() {
        return this.wcRoot;
    }

    public SVNWCDbDir getParent() {
        return this.parent;
    }

    public SVNWCAccess getAdmAccess() {
        return this.admAccess;
    }

    public void setLocalAbsPath(File localAbsPath) {
        this.localAbsPath = localAbsPath;
    }

    public void setWCRoot(SVNWCDbRoot wcRoot) {
        this.wcRoot = wcRoot;
    }

    public void setParent(SVNWCDbDir parent) {
        this.parent = parent;
    }

    public static boolean isUsable(SVNWCDbDir pdh) {
        return pdh != null && pdh.getWCRoot() != null && pdh.getWCRoot().getFormat() == 29;
    }

    public File computeRelPath() {
        String relativePath = SVNPathUtil.getRelativePath(this.wcRoot.getAbsPath().toString(), this.localAbsPath.toString());
        return SVNFileUtil.createFilePath(relativePath);
    }

    public void flushEntries(File localAbspath) throws SVNException {
        SVNWCDbDir parentPdh;
        if (this.admAccess != null) {
            this.admAccess.close();
        }
        if (localAbspath != null && localAbspath.equals(this.localAbsPath) && !localAbspath.equals(this.wcRoot.getAbsPath()) && (parentPdh = this.wcRoot.getDb().navigateToParent(this, SVNSqlJetDb.Mode.ReadOnly)) != null && parentPdh.getAdmAccess() != null) {
            parentPdh.getAdmAccess().close();
        }
    }
}

