/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions.scheduling;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.revisions.scheduling.UpdateIndexMonitor;
import com.atlassian.jira.plugin.ext.subversion.revisions.scheduling.UpdateIndexTask;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class UpdateIndexMonitorImpl
implements UpdateIndexMonitor,
LifecycleAware,
DisposableBean {
    private static final String JOB_NAME = UpdateIndexMonitorImpl.class.getName() + ":job";
    private static final Logger logger = LoggerFactory.getLogger(UpdateIndexMonitorImpl.class);
    private final PluginScheduler pluginScheduler;
    private final MultipleSubversionRepositoryManager multipleSubversionRepositoryManager;
    private static final long DEFAULT_INDEX_INTERVAL = 3600000L;

    public UpdateIndexMonitorImpl(PluginScheduler pluginScheduler, MultipleSubversionRepositoryManager multipleSubversionRepositoryManager) {
        this.pluginScheduler = pluginScheduler;
        this.multipleSubversionRepositoryManager = multipleSubversionRepositoryManager;
    }

    public void onStart() {
        this.schedule();
    }

    @Override
    public void schedule() {
        this.pluginScheduler.scheduleJob(JOB_NAME, UpdateIndexTask.class, (Map)new HashMap<String, Object>(){
            {
                this.put("UpdateIndexMonitorImpl:instance", UpdateIndexMonitorImpl.this);
                this.put("MultipleSubversionRepositoryManager", UpdateIndexMonitorImpl.this.multipleSubversionRepositoryManager);
            }
        }, new Date(), 3600000L);
        logger.info(String.format("UpdateIndexMonitorImpl scheduled to run every %dms", 3600000L));
    }

    public void destroy() {
        try {
            this.pluginScheduler.unscheduleJob(JOB_NAME);
        }
        catch (Exception e) {
            throw new InfrastructureException("Error unschedule update index job " + e);
        }
    }
}

