/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion;

import com.atlassian.jira.plugin.ext.subversion.SubversionManagerImpl;
import com.opensymphony.module.propertyset.PropertySet;

public interface SvnProperties {
    public String getRoot();

    public String getDisplayName();

    public String getUsername();

    public String getPassword();

    public Boolean getRevisionIndexing();

    public Integer getRevisionCacheSize();

    public String getPrivateKeyFile();

    public String getWebLinkType();

    public String getChangesetFormat();

    public String getFileAddedFormat();

    public String getViewFormat();

    public String getFileModifiedFormat();

    public String getFileReplacedFormat();

    public String getFileDeletedFormat();

    public static class Util {
        static PropertySet fillPropertySet(SvnProperties properties, PropertySet propertySet) {
            propertySet.setString("svn.root", properties.getRoot());
            propertySet.setString("svn.display.name", properties.getDisplayName() != null ? properties.getDisplayName() : properties.getRoot());
            propertySet.setString("svn.username", properties.getUsername());
            propertySet.setString("svn.password", SubversionManagerImpl.encryptPassword(properties.getPassword()));
            propertySet.setBoolean("revision.indexing", properties.getRevisionIndexing().booleanValue());
            propertySet.setInt("revision.cache.size", properties.getRevisionCacheSize().intValue());
            propertySet.setString("svn.privatekeyfile", properties.getPrivateKeyFile());
            propertySet.setString("linkformat.type", properties.getWebLinkType());
            propertySet.setString("linkformat.copyfrom", properties.getViewFormat());
            propertySet.setString("linkformat.changeset", properties.getChangesetFormat());
            propertySet.setString("linkformat.file.added", properties.getFileAddedFormat());
            propertySet.setString("linkformat.file.modified", properties.getFileModifiedFormat());
            propertySet.setString("linkformat.file.replaced", properties.getFileReplacedFormat());
            propertySet.setString("linkformat.file.deleted", properties.getFileDeletedFormat());
            return propertySet;
        }
    }
}

