/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.SubversionManagerImpl;
import com.atlassian.jira.plugin.ext.subversion.SubversionProperties;
import com.atlassian.jira.plugin.ext.subversion.SvnProperties;
import com.atlassian.jira.plugin.ext.subversion.SvnPropertiesLoader;
import com.atlassian.jira.plugin.ext.subversion.revisions.RevisionIndexer;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.security.PermissionManager;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;

public class MultipleSubversionRepositoryManagerImpl
implements MultipleSubversionRepositoryManager {
    private static final Logger log = LoggerFactory.getLogger(MultipleSubversionRepositoryManagerImpl.class);
    public static final String APP_PROPERTY_PREFIX = "jira.plugins.subversion";
    public static final String REPO_PROPERTY = "jira.plugins.subversion.repo";
    public static final String LAST_REPO_ID = "last.repo.id";
    public static final long FIRST_REPO_ID = 1L;
    private PropertySet pluginProperties;
    private RevisionIndexer revisionIndexer;
    private Map<Long, SubversionManager> managerMap = new HashMap<Long, SubversionManager>();
    private final JiraPropertySetFactory jiraPropertySetFactory;
    private long lastRepoId;

    public MultipleSubversionRepositoryManagerImpl(VersionManager versionManager, IssueManager issueManager, PermissionManager permissionManager, ChangeHistoryManager changeHistoryManager, JiraPropertySetFactory jiraPropertySetFactory, IndexPathManager indexPathManager) {
        this.jiraPropertySetFactory = jiraPropertySetFactory;
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        this.managerMap = this.loadSvnManagers();
        this.revisionIndexer = new RevisionIndexer(this, versionManager, issueManager, permissionManager, changeHistoryManager, indexPathManager);
    }

    Map<Long, SubversionManager> loadSvnManagers() {
        return this.loadManagersFromJiraProperties();
    }

    private Map<Long, SubversionManager> loadManagersFromJiraProperties() {
        this.pluginProperties = this.jiraPropertySetFactory.buildCachingDefaultPropertySet(APP_PROPERTY_PREFIX, true);
        this.lastRepoId = this.pluginProperties.getLong(LAST_REPO_ID);
        LinkedHashMap<Long, SubversionManager> managers = new LinkedHashMap<Long, SubversionManager>();
        for (long i = 1L; i <= this.lastRepoId; ++i) {
            SubversionManager mgr = this.createManagerFromPropertySet(i, this.jiraPropertySetFactory.buildCachingPropertySet(REPO_PROPERTY, Long.valueOf(i), true));
            if (mgr == null) continue;
            managers.put(i, mgr);
        }
        return managers;
    }

    SubversionManager createManagerFromPropertySet(long index, PropertySet properties) {
        try {
            if (properties.getKeys().isEmpty()) {
                return null;
            }
            return new SubversionManagerImpl(index, properties);
        }
        catch (IllegalArgumentException e) {
            log.error("Error creating SubversionManager " + index + ". Probably was missing a required field (e.g., repository name or root). Skipping it.", (Throwable)e);
            return null;
        }
    }

    Map<Long, SubversionManager> loadFromProperties() {
        HashMap<Long, SubversionManager> managers = new HashMap<Long, SubversionManager>();
        try {
            List<SubversionProperties> propertiesSet = SvnPropertiesLoader.getSVNProperties();
            for (SubversionProperties svnProperties : propertiesSet) {
                SubversionManager mgr = this.createRepository(svnProperties);
                managers.put(mgr.getId(), mgr);
            }
        }
        catch (InfrastructureException ie) {
            log.warn("There's a problem adding a subversion manager.", (Throwable)ie);
        }
        return managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubversionManager createRepository(SvnProperties properties) {
        long repoId;
        MultipleSubversionRepositoryManagerImpl multipleSubversionRepositoryManagerImpl = this;
        synchronized (multipleSubversionRepositoryManagerImpl) {
            repoId = ++this.lastRepoId;
            this.pluginProperties.setLong(LAST_REPO_ID, this.lastRepoId);
        }
        PropertySet set = this.jiraPropertySetFactory.buildCachingPropertySet(REPO_PROPERTY, Long.valueOf(repoId), true);
        SubversionManagerImpl subversionManager = new SubversionManagerImpl(repoId, SvnProperties.Util.fillPropertySet(properties, set));
        this.managerMap.put(subversionManager.getId(), subversionManager);
        if (this.isIndexingRevisions()) {
            this.revisionIndexer.addRepository(subversionManager);
        }
        return subversionManager;
    }

    @Override
    public SubversionManager updateRepository(long repoId, SvnProperties properties) {
        SubversionManager subversionManager = this.getRepository(repoId);
        subversionManager.update(properties);
        return subversionManager;
    }

    @Override
    public void removeRepository(long repoId) {
        SubversionManager original = this.managerMap.get(repoId);
        if (original == null) {
            return;
        }
        try {
            this.managerMap.remove(repoId);
            for (String key : new ArrayList(original.getProperties().getKeys())) {
                original.getProperties().remove(key);
            }
            if (this.revisionIndexer != null) {
                this.revisionIndexer.removeEntries(original);
            }
        }
        catch (Exception e) {
            throw new InfrastructureException("Could not remove repository index", (Throwable)e);
        }
    }

    @Override
    public boolean isIndexingRevisions() {
        return this.revisionIndexer != null;
    }

    @Override
    public RevisionIndexer getRevisionIndexer() {
        return this.revisionIndexer;
    }

    @Override
    public Collection<SubversionManager> getRepositoryList() {
        return this.managerMap.values();
    }

    @Override
    public SubversionManager getRepository(long id) {
        return this.managerMap.get(id);
    }

    void startRevisionIndexer() {
        this.getRevisionIndexer().start();
    }

    public void start() {
        try {
            if (this.isIndexingRevisions()) {
                this.startRevisionIndexer();
            }
        }
        catch (InfrastructureException ie) {
            log.error("Error starting " + this.getClass(), (Throwable)ie);
        }
    }
}

