/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter;

import com.atlassian.jira.mobile.servlet.filter.mapper.MobileURLTrackerService;
import com.atlassian.jira.mobile.utils.MobileUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileRedirectFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MobileRedirectFilter.class);
    private final MobileURLTrackerService mobileURLTrackerService;
    private String redirectPrefix;

    public MobileRedirectFilter(MobileURLTrackerService mobileURLTrackerService) {
        this.mobileURLTrackerService = mobileURLTrackerService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.redirectPrefix = filterConfig.getInitParameter("redirectPrefix");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain next) throws IOException, ServletException {
        String fragment;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        String context = request.getContextPath();
        String path = url.substring(context.length());
        if (MobileUtils.isMobileViewRequest(request) && (fragment = this.mobileURLTrackerService.mapPath(path, request)) != null) {
            String redirectUrl = String.format("%s%s#%s", context, this.redirectPrefix, fragment);
            if (!response.isCommitted()) {
                response.sendRedirect(redirectUrl);
                return;
            }
            log.warn("We wanted to redirect to the JIRA Mobile page '{}', but the HTTP response is already committed to, so we can't.", (Object)redirectUrl);
            if (log.isDebugEnabled()) {
                String requestURL = request.getRequestURL().toString();
                String responseLocation = response.getHeader("location");
                log.debug("Requested URL: '{}', Response location header: '{}'", (Object)requestURL, (Object)responseLocation);
            }
        }
        next.doFilter(servletRequest, servletResponse);
    }
}

