define('layout/base',
    [
        'zepto',
        'underscore',
        'util/ajax',
        'util/app-data',
        'util/auth',
        'util/events',
        'util/hide-address-bar',
        'util/router',
        'util/tracking',
        'feature/filters/favourites',
        'exports'
    ],
    function (
        $,
        _,
        ajax,
        appData,
        auth,
        events,
        hideAddressBar,
        router,
        tracking,
        favouriteFilters,
        exports) {

        function getHistoryOptions() {
            return {
                root: appData.get('context-path') + '/plugins/servlet/mobile'
            }
        }

        // Needed for compat with Atlassian Analytics
        $.toJSON = JSON.stringify;

        // TODO move this constant somewhere
        var MOBILE_DESKTOP_COOKIE = 'jira.mobile.desktop.switch';
        function setDesktopCookie(value) {
           var path = appData.get('context-path');
           if (!path) {
               path = "/";
           }

           var cookieOptions = {
               expires: 3650, // 10 years from now
               path: path,
               raw: true
           };

           // TODO make cookie detection not forever. Consider refactoring out of base.js
           if ( $.cookie(MOBILE_DESKTOP_COOKIE) ) {
               $.cookie(MOBILE_DESKTOP_COOKIE, null, cookieOptions);
           }
           $.cookie(MOBILE_DESKTOP_COOKIE, value, cookieOptions);
        }

        var $userDetails;
        function updateUserDetails() {
            if (!$userDetails) {
                $userDetails = $('.fly-out .current-user');
            }
            var userName = appData.getUsername();
            var userData = appData.get('user-data');

            var $avatar = $userDetails.find('.current-user-avatar');
            var $name = $userDetails.find('.current-user-name');
            if (userData) {
                $avatar.empty();
                $avatar.removeClass('default-avatar');
                $avatar.append(AtlassianMobile.Templates.JIRA.layout.image({
                    src: userData.avatarUrls['48x48']
                }));
                $name.text(userData.displayName);
            } else if (!userName) {
                /**
                 * Only clear this out if there is no user data object AND no user name.
                 * On first page load the user name is provided in a meta tag but not the user data object,
                 *   but the Soy template takes care of rendering the right state.
                 */
                $avatar.empty();
                $avatar.addClass('default-avatar');
                $name.text(AJS.I18n.getText('jira.mobile.nav.user.none'));
            }

            var $link = $('#login-logout');
            var text = userName ? AJS.I18n.getText('jira.mobile.nav.log.out') : AJS.I18n.getText('jira.mobile.nav.log.in');
            $link.text(text);
            return {
                $avatar: $avatar,
                $name: $name,
                $link: $link
            };
        }

        function commonInit(){
            hideAddressBar();
            window.addEventListener('load', function() {
                new FastClick(document.body);
            }, false);

            var switchToDesktopHandler = function (e) {
                var currentView = router.presenter.currentView;
                var desktopUrl = _.result(currentView, 'desktopUrl');
                if (desktopUrl) {
                    e.preventDefault();
                    setDesktopCookie(true);
                    window.location = desktopUrl;
                }
            };

            $('#switch-to-desktop').click(switchToDesktopHandler);
            $('body').on('click', '#switch-to-desktop-footer', switchToDesktopHandler);

            auth.on('login', updateUserDetails);
            auth.on('logout', updateUserDetails);
            updateUserDetails().$link.click(function (e) {
                e.preventDefault();
                if (appData.getUsername()) {
                    auth.logout();
                } else {
                    auth.showLoginPage(false);
                }
            });

            favouriteFilters.init();
        }

        function init() {
            commonInit();
            Backbone.history.start(getHistoryOptions());
        }

        function initLogin() {
            commonInit();
            var options = getHistoryOptions();
            options.silent = true;
            Backbone.history.start(options);

            var LoginView = require('layout/login/login-view');
            new LoginView({
                el: $('.card.login')
            });
        }

        exports.init = init;
        exports.initLogin = initLogin;
    }
);
