define(['../simply-deferred/simply-deferred', './zepto', './zepto.data', './zepto.cookie'], function(Deferred) {
    var Zepto = window.Zepto;
    // Both analytics and our app need a Deferred object to work.
    Deferred.installInto(Zepto);
    // Also... analytics needs JSON parsing.
    Zepto.toJSON = JSON.stringify;
    // Also... analytics eagerly pulls a reference to AJS.$.ajax, so we need to get in early.
    AJS.$ = Zepto;
    // Also... analytics wants a "bind" event.
    var zDoc = Zepto(document);
    AJS.bind = zDoc.bind.bind(zDoc);
    // ALSO!!! analytics wants a toInit function. So greedy!
    AJS.toInit = Zepto.fn.ready;
    // Finally, we have a usable "jQuery" and "AJS" object. Phew!
    return Zepto;
});
