/*
 FastClick: polyfill to remove click delays on browsers with touch UIs.

 @version 0.4.3
 @codingstandard ftlabs-jslint
 @copyright The Financial Times Limited [All Rights Reserved]
 @license MIT License (see LICENSE.txt)
*/
'use strict';function FastClick(a){var b=this;this.trackingClick=!1;this.trackingClickStart=0;this.targetElement=null;this.layer=a;if(!a||!a.nodeType)throw new TypeError("Layer must be a document node");this.onClick=function(){FastClick.prototype.onClick.apply(b,arguments)};this.onTouchStart=function(){FastClick.prototype.onTouchStart.apply(b,arguments)};this.onTouchMove=function(){FastClick.prototype.onTouchMove.apply(b,arguments)};this.onTouchEnd=function(){FastClick.prototype.onTouchEnd.apply(b,
arguments)};this.onTouchCancel=function(){FastClick.prototype.onTouchCancel.apply(b,arguments)};if("undefined"!==typeof window.ontouchstart&&(a.addEventListener("click",this.onClick,!0),a.addEventListener("touchstart",this.onTouchStart,!1),a.addEventListener("touchmove",this.onTouchMove,!1),a.addEventListener("touchend",this.onTouchEnd,!1),a.addEventListener("touchcancel",this.onTouchCancel,!1),"function"===typeof a.onclick)){var c=a.onclick;a.addEventListener("click",function(a){c(a)},!1);a.onclick=
null}}FastClick.prototype.deviceIsAndroid=0<navigator.userAgent.indexOf("Android");FastClick.prototype.needsClick=function(a){switch(a.nodeName.toLowerCase()){case "label":case "video":return!0;default:return/\bneedsclick\b/.test(a.className)}};FastClick.prototype.needsFocus=function(a){switch(a.nodeName.toLowerCase()){case "textarea":case "select":return!0;case "input":switch(a.type){case "button":case "checkbox":case "file":case "image":case "radio":case "submit":return!1}return!0;default:return/\bneedsfocus\b/.test(a.className)}};
FastClick.prototype.maybeSendClick=function(a,b){if(this.needsClick(a))return!1;document.activeElement&&document.activeElement!==a&&document.activeElement.blur();var c=b.changedTouches[0];b=document.createEvent("MouseEvents");b.initMouseEvent("click",!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null);b.forwardedTouchEvent=!0;a.dispatchEvent(b);return!0};
FastClick.prototype.onTouchStart=function(a){var b=a.targetTouches[0];this.trackingClick=!0;this.trackingClickStart=a.timeStamp;this.targetElement=a.target;this.touchStartX=b.pageX;this.touchStartY=b.pageY;200>a.timeStamp-this.lastClickTime&&a.preventDefault();return!0};FastClick.prototype.touchHasMoved=function(a){a=a.targetTouches[0];return 10<Math.abs(a.pageX-this.touchStartX)||10<Math.abs(a.pageY-this.touchStartY)?!0:!1};
FastClick.prototype.onTouchMove=function(a){if(!this.trackingClick)return!0;if(this.targetElement!==a.target||this.touchHasMoved(a))this.trackingClick=!1,this.targetElement=null;return!0};FastClick.prototype.findControl=function(a){return void 0!==a.control?a.control:a.htmlFor?document.getElementById(a.htmlFor):a.querySelector("button, input:not([type\x3dhidden]), keygen, meter, output, progress, select, textarea")};
FastClick.prototype.onTouchEnd=function(a){var b=this.targetElement;if(!this.trackingClick)return!0;if(200>a.timeStamp-this.lastClickTime)return this.cancelNextClick=!0;this.lastClickTime=a.timeStamp;var c=this.trackingClickStart;this.trackingClick=!1;this.trackingClickStart=0;if("label"===b.nodeName.toLowerCase()){if(c=this.findControl(b)){b.focus();if(this.deviceIsAndroid)return!1;this.maybeSendClick(c,a)&&a.preventDefault();return!1}}else if(this.needsFocus(b)){if(100<a.timeStamp-c)return this.targetElement=
null,!0;b.focus();"select"!==b.tagName.toLowerCase()&&a.preventDefault();return!1}if(!this.maybeSendClick(b,a))return!1;a.preventDefault();return!1};FastClick.prototype.onTouchCancel=function(){this.trackingClick=!1;this.targetElement=null};
FastClick.prototype.onClick=function(a){if(a.forwardedTouchEvent||!this.targetElement)return!0;var b=this.targetElement;this.targetElement=null;return!a.cancelable||"submit"===a.target.type&&0===a.detail?!0:!this.needsClick(b)||this.cancelNextClick?(this.cancelNextClick=!1,a.stopImmediatePropagation&&a.stopImmediatePropagation(),a.stopPropagation(),a.preventDefault(),!1):!0};
FastClick.prototype.destroy=function(){var a=this.layer;a.removeEventListener("click",this.onClick,!0);a.removeEventListener("touchstart",this.onTouchStart,!1);a.removeEventListener("touchmove",this.onTouchMove,!1);a.removeEventListener("touchend",this.onTouchEnd,!1);a.removeEventListener("touchcancel",this.onTouchCancel,!1)};"function"===typeof define&&define.amd&&define(function(){return FastClick});
"undefined"!==typeof module&&module.exports&&(module.exports=function(a){return new FastClick(a)},module.exports.FastClick=FastClick);