/**
 * Simple base View class for all other full-page views to inherit from.
 *
 * Handles common logic for all full-page views, such as header/content separation and loading spinners.
 */
define('layout/base/page-view', ['zepto', 'backbone', 'require'], function ($, Backbone, require) {
    const PageView = Backbone.View.extend({
        header: null,
        loadingOverlay: null,
        hasSpinner: false,

        /**
         * Show a full page loading spinner (with cancel) that prevents tap/scroll
         */
        showLoading: function () {
            if (this.loadingOverlay) {
                this.loadingOverlay.showLoading();
                this.hasSpinner = true;
            }
        },

        /**
         * Show a small loading spinner in the header, for use with in-page actions
         */
        showHeaderLoading: function () {
            if (this.header) {
                this.header.showLoading();
                this.hasSpinner = true;
            }
        },

        /**
         * Remove any active loading spinners
         */
        hideLoading: function () {
            if (this.hasSpinner) {
                this.header.hideLoading();
                this.loadingOverlay.hideLoading();
            }
        },

        showSuccess: function () {
            if (this.header) {
                this.header.showSuccess();
            }
        },

        /**
         * Cancel any AJAX requests that are currently active for this view
         */
        cancelLoading: function () {
            const ajax = require('util/ajax');
            ajax.cancelActiveRequests();
        }
    });

    return PageView;
});
